import numpy as np


def interpolate_to_target_frames(array: np.ndarray, target_T: int) -> np.ndarray:
        """Interpolazione lineare vettorizzata lungo Y.

        Parameters
        ----------
        array : np.ndarray
            Tensore (x, y, z)
        target_T : int
            Nuova dimensione lungo y

        Returns
        -------
        np.ndarray
            Tensore (x, target_T, z)
        """
        from scipy.interpolate import interp1d
        H, T, W = array.shape
        if T == target_T:
            return array.astype(array.dtype, copy=False)
        x_old = np.linspace(0.0, 1.0, T, dtype=np.float32)
        x_new = np.linspace(0.0, 1.0, target_T, dtype=np.float32)
        f = interp1d(x_old, array, kind='linear', axis=1, assume_sorted=True)
        return f(x_new).astype(array.dtype, copy=False)


