/**
 * __   __      _                       ______                _____            
 * \ \ / /     | |                      |  _  \              |  __ \           
 *  \ V / _ __ | | ___  _ __ __ _ ______| | | |___  ___ _ __ | |  \/ ___  ___  
 *  /   \| '_ \| |/ _ \| '__/ _` |______| | | / _ \/ _ \ '_ \| | __ / _ \/ _ \ 
 * / /^\ \ |_) | | (_) | | | (_| |      | |/ /  __/  __/ |_) | |_\ \  __/ (_) |
 * \/   \/ .__/|_|\___/|_|  \__,_|      |___/ \___|\___| .__/ \____/\___|\___/ 
 *       | |                                           | |                     
 *       |_|                                           |_|                     
 */
#include <iostream>
#include "./utils/Matrix3D.hh"
#include "./utils/Point3D.hh"
#include "./utils/PCAResult.hh"
#include "./utils/ImageLoader.hh"
#ifdef USE_STD
#include "utils/configurations/configSTD.hh"
#endif
#ifdef USE_ALT1
#include "utils/configurations/configALT1.hh"
#endif

struct DeepGeo{
    public:
    Matrix3D<float> *matrixPtr = nullptr; // contiene matrice di valori e matrice di codici
    Matrix3D<float> matrix;
    int offsetUp;
    int offsetDx;
    int offsetDown;
    int offsetSx;
    int offsetZ;
    
    vector<PCAResult> pcaResults; // autovet - autoval - maxlocali - baricentri - score - value - D1 - D1_2
    vector<Point3D> maxLocalPoints; // lista di maxLocali
    vector<Point3D> baricentroPoints; // lista di baricentri
    int localMaxSize;
    vector<vector<Point3D>> localMaxList;
    vector<vector<Stats>> statCoppie; 
    void addMatrix(Matrix3D<float> *matrix);
    void addPcaResult(const vector<PCAResult> &pcaResults);
    vector<PCAResult> getPcaResult();
    vector<Point3D> getMaxPoints();

};
void DeepGeo::addMatrix(Matrix3D<float> *matrix){
	this->matrixPtr = matrix;
}
void DeepGeo::addPcaResult(const vector<PCAResult> &pcaResults){
	this->pcaResults = pcaResults;
	
	// creo il mio vettore di maxLocali e di baricentri da disegnare e la linea che li collega
	for(const auto& pca : pcaResults){
		this->maxLocalPoints.push_back(pca.maxLocale);
        this->baricentroPoints.push_back(pca.baricentro);
    	}
}

vector<PCAResult> DeepGeo::getPcaResult(){
	return this->pcaResults;
}

vector<Point3D> DeepGeo::getMaxPoints(){
	return this->maxLocalPoints;
}