#ifndef GRAPH__HH
#define GRAPH__HH

#include <iostream>
#include <vector>
#include "Matrix3D.hh"
#include "Point3D.hh"
#include "Line.hh"
#include "MinHeap.hh"
#include "Stats.hh"
#include "PCAResult.hh"
#include "RadMatrixElement.hh"
#include "outputJson.hh"
#include "Evaluation.hh"
#include <thread>
#include <chrono>
#include <mutex>
#include <list>
#include <unordered_map>
#include <unordered_set>
#include <set>

using namespace std;

class Graph {
    private: 

        struct Vertex{
            float distance;
            float value;
            bool visited;
            int prev;
            bool flagEscluso = false; // se flag escluso == 1 --> non prendibile nello shortestpath
            float distEuclidea; 
        };
        struct Edge
        {
            int to; // id nodo di destinazione 
            float direction; // score di statistiche coppie  
            float delta; 
            bool visited;

            Edge() : to(-1), direction(-1.0f), delta(-1.0f), visited(false) {}
            Edge(int to) : to(to), direction(-1.0f), delta(-1.0f), visited(false) {}
            Edge(int to, float direction) : to(to), direction(direction), delta(-1.0f), visited(false) {}
            Edge(int to, float direction, float delta) : to(to), direction(direction), delta(delta), visited(false) {}
        };

        vector<Vertex> vertex;
        vector<vector<Edge>> edges; 
        Matrix3D<float> matrix; 
        vector<Point3D> maxList;
        vector<Line> lines; 
        vector<Point3D> stackPunti; 

        float norm(Point3D& P);
        
        Point3D linearRegression(std::vector<int> &linearRegPoints, int from, int to);
        float distance(float dz, float dy, float dx);
         // void ricercaRicorsiva(int current, vector<Point3D> &stackPunti, float &bestScore, vector<Point3D> &migliorAttuale);
        bool ricercaRicorsiva(int current, vector<int> &stackPunti, float &bestScore, vector<int> &migliorAttuale,Point3D dir, int lev);
        bool ricercaRicorsivaMax(int current, std::vector<int> &stackPunti, float &bestScore, std::vector<int> &migliorAttuale, Point3D dir, int lev);



    public: 
        //Distanza massima tra due nodi del grafo, usata per normalizzare
        float maxDistance=0;
        float diametro;
        float diametroOOF;
        float diametroRR;
        int epoca=0;
        int contaTubi=0;

        //parametri di offset per json
        int offsetUp;
        int offsetDown;
        int offsetLeft;
        int offsetRight;
        int offsetZ;
        string m_jsonPath;

        vector<PCAResult> nodi;
        vector<Point3D> radPoints;
        vector<Line> sectionCircle;
        vector<Line> cylinders;
        vector<TuboJSON> tubiJson;
        Graph(vector<PCAResult> pcaResults, vector<vector<Stats>> stats, const string& jsonOutputPath);
        
        
        void addMatrix(Matrix3D<float>& matrix);
        void addMaxLocals(vector<Point3D> maxList);

        vector<Line>& getLines(); 
    
        

        float getMaxDistance();
        float distance(const Point3D &p1, const Point3D &p2);
        
        bool isBaricenter(int x, int y, int z);
        bool isMaxLocal(const Point3D &maxLocal);

        void shortestPath(int from, MinHeap &heap);
        void shortestPathMax(int from, MinHeap &heap);
        void startShortestPath();
        void startShortestPathMax();
        float getDiameterFromPCA(const Point3D& bar, const float autovetMax[3], const float autovetMid[3], const float autovetMin[3]);

        int findNodeIndex(const Point3D &point);
}; 


#endif
