#ifndef IMGLOADER__HH
#define IMGLOADER__HH

#include <vector>
#include <filesystem>
#include <opencv2/opencv.hpp>
#include "Matrix3D.hh"
using namespace std;
namespace fs = filesystem;

class ImageLoader {
    private:
        
        float INFT = 999999.0d;
        Matrix3D<float> matrix3d; 

        double gauss(double sigma, double x); 
        void gausKernel(float *&kernel, int samples, double sigma); 
        void gaussSmoothenX(float *&kernel, Matrix3D<float> &mat, Matrix3D<float> &out, int y, int z, double sigma, int samples); 
        void gaussSmoothenY(float *&kernel, Matrix3D<float> &mat, Matrix3D<float> &out, int x, int z, double sigma, int samples);
        void gaussSmoothenZ(float *&kernel, Matrix3D<float> &mat, Matrix3D<float> &out, int x, int y, double sigma, int samples);

        vector<fs::directory_entry> getFiles(string path); 
        bool contains(string file, vector<fs::directory_entry> files); 
        void resizeGeoreferencedTiff(const string &inputPath, const string &outputPath, double targetGSD);

        static void ensureDirectoryExists(const std::string &path);

        static bool compareFilenames(const fs::directory_entry &a, const fs::directory_entry &b);
        
    public: 
        struct CroppedPixels {
            int top;
            int bottom;
            int left;
            int right;
        };
        int z;
        int top;
        int bottom;
        int left;
        int right;
        CroppedPixels calculateCroppedPixels(const cv::Mat &image);
        ImageLoader();

        void loadImages(string dirName = ""); 
        void loadBinaryTomography(string binaryFile);   // NUOVO: Carica formato binario
//         void loadBin(string fileName = "");
//         void save(string fileName = "");
//         void splitBin(string fileName, int splitSizeX, int splitSizey);
        void applyGauss(int sigma = 5);
        void processGeoreferencedImages(const std::string &inputDir, const std::string &outputDir, double targetGSD);
        Matrix3D<float>& getMatrix();  
};

#endif