#ifndef LINE__HH
#define LINE__HH

#include "Point3D.hh"

class Line
{
private:
    Point3D a;
    Point3D b;
    //Intensità
    float value;

public:
    Line(Point3D a, Point3D b, float value);

    const Point3D& getA() const;
    const Point3D& getB() const;
    float getValue() const;
    void print();
};
/**
 * @brief Costruttore della classe Line
 * 
 * Inizializza una linea con due punti 3D e un valore di intensità.
 * 
 * @param a Il primo punto 3D della linea.
 * @param b Il secondo punto 3D della linea.
 * @param value Il valore di intensità della linea.
 */
inline Line::Line(Point3D a, Point3D b, float value){
    this->a = a;
    this->b = b;
    this->value = value; 
}
/**
* @brief Ottiene il primo punto 3D della linea
* 
* @return const Point3D& Un riferimento costante al primo punto 3D della linea.
*/
inline const Point3D& Line::getA() const{
    return this->a;
}
/**
* @brief Ottiene il secondo punto 3D della linea
* 
* @return const Point3D& Un riferimento costante al secondo punto 3D della linea.
*/
inline const Point3D& Line::getB() const{
    return this->b;
}
/**
* @brief Ottiene il valore di intensità della linea
* 
* @return float Il valore di intensità della linea.
*/
inline float Line::getValue() const{
    return this->value;
}

/**
* @brief Questa funzione stampa in output i due punti per cui passa la linea
*  e la sua intensità
* 
* @return void
*/
inline void Line::print() {
    a.print();
    b.print();
    cout<<"Value: "<<value<<endl;
}

#endif