#ifndef MATRIX3D__HH
#define MATRIX3D__HH

#include "Point3D.hh"
#include <iostream>
#include <vector>
#include <stdexcept>
#include <opencv2/opencv.hpp>
#include <fstream>
#include <array>
#include "libraries/dsyevj3.hh"
#include "PCAResult.hh"

using namespace std; 

template <typename T>
class Matrix3D{
    private:

        // Matrice di valori
        T ***data; // valori matrice tridimensione [x][y][z]
        T *data_flatten; // valori matrice piatti (per texture) [x+y+z]

        // size della nostra matrice 3D
        size_t totalElements;
        size_t x, y, z;

        bool isEmptyRow(const cv::Mat &mat, int row);
        bool isEmptyCol(const cv::Mat & mat, int col);
        array<int, 4> getRowsCols(const cv::Mat &mat);
        int startRow;
        int startColumn;

    public:
       
        // Matrice di codici
        vector<vector<vector<int>>> codici; // matrice  codici [x][y][z]
        int* condiciFlatten; // matrice codici piatti [x+y+z]

        vector<vector<vector<int>>> flag; // matrice  codici [x][y][z]
        int* flagFlat; // matrice codici piatti [x+y+z]

        Matrix3D();  //costruttore default
        Matrix3D(size_t dim, const cv::Mat &mat); //costruzione matrice con numero delle immagini, da una matrice OpenCV e una dimensione
        Matrix3D(string binary_path, string binary_file); //caricare binario data
        Matrix3D(size_t x, size_t y, size_t z); //con dimensioni specifiche

        Matrix3D(const Matrix3D &other);
        Matrix3D(Matrix3D &&other) noexcept;

        Matrix3D &operator=(const Matrix3D &other); //permette la copia e il movimento delle istanze della matrice
        Matrix3D &operator=(Matrix3D &&other) noexcept;

        ~Matrix3D();

        int getX() const; //dim
        int getY() const;
        int getZ() const;

        void save(string path, string fileName); // salva in memoria la matrice caricata
        T operator()(size_t x, size_t y, size_t z) const; //ritorna valore cella
        T &operator()(size_t x, size_t y, size_t z);
        void set(size_t x, size_t y, size_t z, T v);
        void createFromCV(const cv::Mat &mat, int pox);

        void print();
        void printSize();

        T *ptr(int z, int y) const; // funzione per ottenere un puntatore a una riga specifica della matrice

        // funzione che appiatisce la matrice 3D, mi restituisce un flatten di un z specifica e mi trova il valore nel flatte date x,y,z
        T* getSlicePtr(int z) const;
        void flatten();
        T index(size_t x_index, size_t y_index, size_t z_index);

        T getValData(int x, int y, int z) const;
        float getRadiusFromPCA(const PCAResult& pca);

        void invertBinaryValues(); //inverte i valori della matrice

        void setCodici(vector<vector<vector<int>>> codici);
        void codFlatten();
        int* getCodiciFlatten(int z) const;

        void setFlag(vector<vector<vector<int>>> flag);
        void flagFlatten();
        int* getflagFlatten(int z) const;
};


extern template class Matrix3D<int>; 
extern template class Matrix3D<float>; 

#endif