#ifndef MATRIX3DANALYSIS_HH
#define MATRIX3DANALYSIS_HH

#include <vector>
#include <iostream>
#include "Point3D.hh"
#include "Matrix3D.hh"
#include "Line.hh"
#include "PCAResult.hh"
#include "Stats.hh"

using namespace std;

// struct PCAResult {
//     float score;
//     float dir[3];
//     float dirMin[3];
//     float dirMedio[3];
//     float autovalore[3];
//     int x, y, z;  //coordinate pca
//     float D1; 
//     float D1_2;
//     Point3D c; 
// };

// struct Stats{
//     int conteggio;
//     float angolo;
//     float valMax;
//     float valMedio;
//     float score;
//     float pesoAngolo;
// };

template <typename T>
class Matrix3DAnalysis 
{

    private:
        vector<vector<vector<int>>> codici;
        vector<vector<vector<int>>> flag;
        vector<PCAResult> pcaResults;
        Matrix3D<T>& matrix; 

        
        // ---
        vector<vector<Stats>> statCoppie;
        vector<vector<Stats>> statCoppieBar;
        vector<Point3D> posMaxLocal;
        vector<Point3D> posBarycenter;
        vector<Line> lineeStat;
        vector<Line> lineeStatBarycenter;

        void calcolaStatistiche(bool isBaricentri, const std::vector<Point3D>& posList, std::vector<std::vector<Stats>>& statCoppie, std::vector<Line>& lineeStat);

    public:
        Matrix3DAnalysis(Matrix3D<T> &matrix) : matrix(matrix) {}
        int localMaxSize = 0;
        vector<vector<Point3D>> localMaxList;
        vector<vector<vector<int>>> getCodici();
        vector<vector<vector<int>>> getFlag();
        
        void assignRec(int x, int y, int z);
        void maxAnalysis();
        void findLocalMaxima();
        void pcaAnalysis();   
        const vector<vector<Point3D>>& getLocalMaxList() const;
        const vector<PCAResult>& getPCAResults() const;
        const vector<Line>& getStats() const;
        const vector<Line>& getStatsBarycenter() const; 
        const vector<vector<Stats>>& getStatsCoppie() const;
        const vector<vector<Stats>>& getStatsCoppieBar() const;
        // ---
        void statistiche();
        void statisticheBaricentri(const std::vector<PCAResult>& pcaResults); 

        Point3D vettore(int i, int j, int k);

};

extern template class Matrix3DAnalysis<float>; 

#endif