#ifndef MIN_HEAP__HH
#define MIN_HEAP__HH

#include <iostream>
#include <vector>
#include <algorithm>
#include <unordered_map>

class MinHeap
{
private:
    // long MAX_SIZE = 0;
    float *heap;
    long *id2Heap;
    long *heap2Id;

    void heapifyUp(long index);
    void heapifyDown(long index);
    long parent(long i);
    long leftChild(long i);
    long rightChild(long i);
    long is_leaf(long n);

    void swap(long i, long j);

public:
    float INF = 99999999999999999999999999999999999999.0f;
    MinHeap();
    MinHeap(long capacity);

    ~MinHeap();

    long MAX_SIZE = 0;
    long heap_size = 0;
    void insert(long id, float newValue);
    void decreaseKey(long id, float newValue);
    long extractMinID();
    bool isEmpty();
    bool containsID(long id) const;
    void reset();
    void print();
};

#endif