#ifndef PCARESULT_H
#define PCARESULT_H 

#include <math.h>
#include <iostream> 
#include <vector>
#include <stdexcept>
#include <fstream>
#include <array>
#include "Point3D.hh"

using namespace std; 
/**
 * @struct PCAResult
 * @brief Struct contenente:
 *  - Score della PCA
 *  - Vettore tridimensionale autovettore massimo
 *  - Vettore tridimensionale autovettore medio
 *  - Vettore tridimensionale autovettore piccolo
 *  - Soglia D1
 *  - Soglia D1_2
 *  - Distanza tra massimo e baricentro
 *  - Il punto di massimo locale
 *  - Il punto di baricentro
 */
struct PCAResult{
    float score;
    float autovetMax[3];
    float autovetMid[3];
    float autovetMin[3];
    float autovalore[3];
    float D1; 
    float D1_2;
    float distance_c_max;
    float distance_c_max_raw;
    //Massimo Locale
    Point3D maxLocale;
    //Baricentro
    Point3D baricentro;
};

#endif

