#ifndef RAD_MATRIX_ELEMENT_HH
#define RAD_MATRIX_ELEMENT_HH
#include <vector>
#include <cmath>
#include "Point3D.hh"
// Struttura per memorizzare i dati di ogni punto della matrice
struct RadMatrixElement {
    Point3D coord; // Coordinate 3D del punto della cella della matrice
    float accumulo;  // Valore inizializzato a 0
    int conteggio;  // Valore inizializzato a 0
    float distPointPlane=-1; //distanza Punto-Piano del punto proiettato
    bool outOfMatrix=true; //flag se coordinate sono fuori da ImageMatrix

    RadMatrixElement() : coord(Point3D(-1, -1, -1)), accumulo(0.0f), conteggio(0), distPointPlane(-1) {}
    RadMatrixElement(const Point3D& point) : coord(point), accumulo(0.0f), conteggio(0), distPointPlane(-1) {}
};

#endif