#ifndef SPLOCAL_HH
#define SPLOCAL_HH

#include "Matrix3D.hh"
#include "Point3D.hh"
#include "MinHeap.hh"
#include "Line.hh"
#include "Matrix3DAnalysis.hh"
#include <vector>
#include <mutex>
using namespace std; 

class SpLocal 
{
    private: 
        Matrix3D<float> &matrix; // riferimento alla matrice 
        const vector<vector<Point3D>> &localMaxList; 
        const vector<vector<Stats>> &statCoppie; 
        vector<vector<Point3D>> pathPoints; 
        vector<vector<Line>> lines;

        //helper per shortest path in parallelo 
        void shortestPathOnThread(int id, int from, int to, int lato, int maxNeighbors, mutex &mtxPoints, mutex &mtxEdges, int sizeX, int sizeY, int sizeZ); 
        
        //aggiorna archi e calcola percorsi brevi 
        void updatePaths(int from, MinHeap &heap, float *cost, int *prev, int lato, int sizeX, int sizeY, int sizeZ, mutex &mtxPoints, mutex &mtxEdges);
        
        //helper per aggiornare i costi e le direzioni del percorso
        void updateEdge(int idU, int idV, int sizeX, int sizeY, int sizeZ, float direction, float delta, MinHeap &heap, float *cost, int *prev, mutex &mtxPoints, mutex &mtxEdges);

        // Funzione per calcolare l'ID del punto nella matrice
        long getId(int mz, int my, int mx, int z, int y, int x, int lato);

        // Funzione per ottenere le coordinate 3D dal punto ID
        Point3D getZYX(int sizeZ, int sizeY, int sizeX, long id);

    public:
        // Costruttore con la matrice 3D e i massimi locali
        SpLocal(Matrix3D<float> &matrix, const vector<vector<Point3D>> &localMaxList, const vector<vector<Stats>> &statCoppie);

        // Esegui lo shortest path con più thread
        void shortestPathOnMatrix(int sizeX, int sizeY, int sizeZ);

        // Restituisci il percorso più breve calcolato
        vector<vector<Point3D>> &getPathPoints();

        // Restituisci le linee del grafo calcolate
        vector<vector<Line>> &getLines();
};

#endif