# LOGICA DI SPLITTING DELLA SWATH
# 1. Controllo dei slices_count
# 2. if slices_count < 500 --> swath unica
# 3. if slices_count > 500 --> swath separata a 400 e creo subswath da 400 slices_count con un 30 di overalp 

def split_swath(slices_count, block_size=400, min_tail=90, merge_limit=500):
    if slices_count < merge_limit:
        return [(0, slices_count - 1)]  # swath unica

    step = block_size
    blocks = []
    start = 0

    # Fase 1: generazione blocchi standard
    while start + block_size <= slices_count:
        blocks.append((start, start + block_size - 1))
        start += step

    # Fase 2: gestire la coda finale (resto)
    if start < slices_count:
        tail_size = slices_count - start
        if tail_size >= min_tail:
            # Accetto un blocco finale più corto (senza forzare a 400)
            blocks.append((start, slices_count - 1))
        elif len(blocks) >= 1:
            # Provo a fondere l'ultimo con il precedente
            penultimate_start = blocks[-1][0]
            total_size = slices_count - penultimate_start
            if total_size < merge_limit:
                blocks[-1] = (penultimate_start, slices_count - 1)
            else:
                # Ricalcolo con step più largo
                num_blocks = max((slices_count - min_tail) // step, 1)
                step_new = (slices_count - block_size) // num_blocks
                blocks = []
                start = 0
                while start + block_size <= slices_count:
                    blocks.append((start, start + block_size - 1))
                    start += step_new
                if slices_count - start >= min_tail:
                    blocks.append((start, slices_count - 1))
        else:
            # fallback blocco unico
            blocks = [(0, slices_count - 1)]

    return blocks


def split_swath_with_overlap(slices_count, block_size=400, overlap=30, min_tail=90, merge_limit=500):
    if slices_count < merge_limit:
        return [(0, slices_count - 1)]  # swath unica

    step = block_size - overlap
    blocks = []
    start = 0

    # Fase 1: generazione blocchi standard
    while start + block_size <= slices_count:
        blocks.append((start, start + block_size - 1))
        start += step

    # Fase 2: gestire la coda finale (resto)
    if start < slices_count:
        tail_size = slices_count - start
        if tail_size >= min_tail:
            # Accetto un blocco finale più corto (senza forzare a 400)
            blocks.append((start, slices_count - 1))
        elif len(blocks) >= 1:
            # Provo a fondere l'ultimo con il precedente
            penultimate_start = blocks[-1][0]
            total_size = slices_count - penultimate_start
            if total_size < merge_limit:
                blocks[-1] = (penultimate_start, slices_count - 1)
            else:
                # Ricalcolo con step più largo
                num_blocks = max((slices_count - min_tail) // step, 1)
                step_new = (slices_count - block_size) // num_blocks
                blocks = []
                start = 0
                while start + block_size <= slices_count:
                    blocks.append((start, start + block_size - 1))
                    start += step_new
                if slices_count - start >= min_tail:
                    blocks.append((start, slices_count - 1))
        else:
            # fallback blocco unico
            blocks = [(0, slices_count - 1)]

    return blocks
