from PySide6.QtCore import QObject, Slot, Signal

class JSBridge(QObject):
    zoomChanged = Signal()
    mapClicked = Signal(float, float)
    depthChanged = Signal(int)
    zoomBoundsChanged = Signal(float, float, float, float, int)  # minLat, minLng, maxLat, maxLng, zoomLevel 

    @Slot(result=str)
    def ping(self):
        print("[JSBridge] ping() chiamato da JS")
        return "pong"

    @Slot(int)
    def onDepthChanged(self, value):
        print(f"[JSBridge] Ricevuto dallo slider JS: {value} cm")
        self.depthChanged.emit(value)

    @Slot(float, float)
    def onMapClicked(self, lat, lng):
        print(f"[JSBridge] Mappa cliccata a: {lat}, {lng}")
        self.mapClicked.emit(lat, lng)
        return True

    @Slot()
    def onZoom(self):
        print("[JSBridge] Zoom event")
        self.zoomChanged.emit()
        return True
    
    @Slot(float, float, float, float, int)
    def onZoomBounds(self, minLat, minLng, maxLat, maxLng, zoomLevel):
        print(f"[JSBridge] Bounds zoom: lat[{minLat}, {maxLat}], lng[{minLng}, {maxLng}], zoom: {zoomLevel}")
        self.zoomBoundsChanged.emit(minLat, minLng, maxLat, maxLng, zoomLevel)
        return True
