# Guida: Struttura Dati e Cartelle

## Panoramica

Il sistema usa **3 cartelle separate** per gestire i dati in modi diversi:

```
SubSwath00/
├── Data/                    → Canali ORIGINALI (mai modificati)
├── Data_current_filter/     → Canali FILTRATI (preservati)
├── Data_AI/                 → Canali con INFERENZA AI (rebuild)
├── tomography/              → Tomografie base
├── tomography_inferenza/    → Tomografie AI
└── georef/                  → Dati georeferenziazione
```

---

## 📁 Cartelle Dati

### 1. `Data/` — Dati Originali

**Contenuto**: Canali raw da OGPR (non filtrati)

- File: `channel_00.npy`, `channel_01.npy`, ...
- **MAI modificati** dopo l'import iniziale
- Servono come backup originale

**Quando viene popolata**:

- Durante l'import survey iniziale da file OGPR

---

### 2. `Data_current_filter/` — Dati Filtrati

**Contenuto**: Canali dopo applicazione filtri (pre-AI)

- File: `channel_00.npy`, `channel_01.npy`, ...
- **Preservati** anche dopo rebuild AI
- Usati come INPUT per l'inferenza AI

**Quando viene popolata**:

- Durante l'import survey, dopo applicazione filtri automatici
- Può essere aggiornata applicando nuovi filtri da GUI
- **NON viene sovrascritto** dall'AI

**Usato da**:

- Visualizzazione radargram (dati filtrati)
- Input per RunAI (inferenza AI)

---

### 3. `Data_AI/` — Dati con Inferenza AI ⭐ NUOVO

**Contenuto**: Maschere generate dall'inferenza AI

- File: `channel_00.npy`, `channel_01.npy`, ...
- File: `ai_model_metadata.json` (versione modelli usati)
- **Sovrascritto** ogni volta che fai rebuild

**Quando viene popolata**:

- Quando fai "AI elaboration" (prima volta)
- Quando fai "Rebuild with new models"

**Usato da**:

- Creazione `tomography_inferenza/`
- Generazione tiles con dati AI
- Processing multiPHT

---

## 🔄 Flusso Dati Completo

### Import Survey

```
OGPR file
    ↓ Lettura raw
    → Data/ (originali salvati)
    ↓ Applica filtri automatici
    → Data_current_filter/ (filtrati salvati)
    ↓ Crea tomografie base
    → tomography/depth_XXXcm.npy
```

### AI Elaboration (Prima Volta)

```
Data_current_filter/
    ↓ Carica in RunAI
    ↓ Applica modelli AI
    → Data_AI/ (maschere AI salvate)
    ↓ Crea tomografie inferenza
    → tomography_inferenza/depth_XXXcm.npy
    ↓ Genera tiles
    → tiles/tile_XXXXXX/depth_XXX.npy
    ↓ multiPHT
    → tiles/tile_XXXXXX/PNG/*.png + JSON
```

### Rebuild with New Models

```
Data_current_filter/ (NON toccato)
    ↓ Ricarica in RunAI
    ↓ Applica NUOVI modelli AI
    → Data_AI/ (SOVRASCRIVE maschere)
    ↓ Ricrea tomografie inferenza
    → tomography_inferenza/ (rigenerate)
    ↓ Rigenera tiles
    → tiles/tile_XXXXXX/ (rigenerati)
    ↓ multiPHT
    → tiles/tile_XXXXXX/PNG/*.png + JSON
```

---

## 🎯 Vantaggi della Nuova Struttura

### ✅ Dati Filtrati Preservati

- `Data_current_filter/` non viene mai sovrascritto dall'AI
- Puoi sempre tornare ai dati filtrati originali
- Rebuild infiniti senza perdere i filtrati

### ✅ Tracciabilità

- `Data_AI/ai_model_metadata.json` traccia i modelli usati
- Hash MD5, timestamp, percorsi modelli
- Sapere sempre quale versione ha generato i dati

### ✅ Separazione Responsabilità

- `Data/` → sola lettura, backup
- `Data_current_filter/` → filtri manuali
- `Data_AI/` → output AI, rebuild-safe

---

## 📊 Comparazione Prima/Dopo

### PRIMA (Vecchia Struttura)

```
Data_current_filter/
  ├── channel_00.npy  ← SOVRASCRITTO dall'AI 😱
  └── channel_01.npy  ← Perdita dati filtrati
```

### DOPO (Nuova Struttura)

```
Data_current_filter/
  ├── channel_00.npy  ← Filtrati, PRESERVATI ✅
  └── channel_01.npy

Data_AI/
  ├── channel_00.npy  ← AI, rebuild-safe ✅
  ├── channel_01.npy
  └── ai_model_metadata.json
```

---

## 🔧 Operazioni Pratiche

### Applicare Nuovi Filtri (senza AI)

1. Applica filtri da GUI
2. `Data_current_filter/` viene aggiornato
3. `Data_AI/` rimane invariato
4. Per usare i nuovi filtri con AI → fai rebuild

### Cambiare Modelli AI

1. Inserisci nuovo percorso modello in GUI
2. Clicca "Rebuild with new models"
3. `Data_current_filter/` rimane invariato ✅
4. `Data_AI/` viene sovrascritto con nuove maschere
5. Tiles e multiPHT rigenerati

### Tornare ai Dati Originali

- `Data/` è sempre disponibile
- Riapplica filtri da `Data/` se necessario

### Comparare Versioni AI

- Salva `Data_AI/` prima del rebuild (backup manuale)
- Confronta `ai_model_metadata.json` per versioni

---

## 📝 Note Implementative

### File `ai_model_metadata.json`

```json
{
  "timestamp": "2025-10-27T12:30:00",
  "models": {
    "longitudinale": {
      "path": "X:\\..\\best_model.pth",
      "hash": "5df624bb...",
      "modified": "2025-10-17T11:47:41"
    },
    "trasversale": { ... },
    "manhole": { ... }
  }
}
```

### Cartelle Create Automaticamente

Tutte le cartelle vengono create da `SubSwath.__init__()`:

- `Data/`
- `Data_current_filter/`
- `Data_AI/` ⭐ nuovo
- `tomography/`
- `georef/`

### Compatibilità Progetti Esistenti

- Progetti vecchi non hanno `Data_AI/`
- Viene creato automaticamente al primo rebuild
- Nessuna migrazione necessaria

---

## 🚨 Attenzione

### ❌ NON Modificare Manualmente

- Non copiare file tra `Data_current_filter/` e `Data_AI/`
- Usa sempre "Rebuild" per rigenerare `Data_AI/`

### ⚠️ Rebuild Sovrascrive

- `Data_AI/` viene completamente sovrascritto
- Se vuoi preservare una versione AI, fai backup manuale

### ✅ Sempre Sicuro

- `Data/` → mai toccato
- `Data_current_filter/` → preservato dall'AI
- `Data_AI/` → rebuild-safe, riproducibile

---

## 🎓 FAQ

**Q: Cosa visualizza il radargram?**  
A: Di default `Data_current_filter/` (dati filtrati). Con checkbox "Show inference" può mostrare `tomography_inferenza/`.

**Q: Cosa succede se cancello `Data_AI/`?**  
A: Niente di grave. Fai "Rebuild" per rigenerarlo da `Data_current_filter/`.

**Q: Posso fare rebuild multipli?**  
A: Sì! `Data_current_filter/` è sempre disponibile come input pulito.

**Q: Come torno ai dati filtrati dopo AI?**  
A: Semplicemente guarda `Data_current_filter/`, è sempre lì. Il radargram mostra già quelli.

**Q: Serve cancellare tiles prima di rebuild?**  
A: No, vengono sovrascritti automaticamente.

---

## 📌 Riferimenti Codice

- Creazione cartelle: `Model/SubSwath.py` (linee 33-40)
- Salvataggio `Data_current_filter`: `Thread/ReadFile.py` (linee 262-269)
- Salvataggio `Data_AI`: `Thread/RunAI.py` (linee 188-201)
- Creazione tomografia inferenza: `Model/SubSwath.py` (linee 183-193)
- Rebuild pipeline: `Controller/Main/ElaborationController.py` (metodo `rebuild_inference_pipeline`)

---

## Changelog

### v2.0 (2025-10-27)

- ✅ Aggiunta cartella `Data_AI/` separata
- ✅ `Data_current_filter/` preservato dall'AI
- ✅ Rebuild non distruttivo
- ✅ Metadata tracciamento modelli in `Data_AI/`
