// CREAZIONE BRIDGE JS <--> PYTHON
function initBridge(map) {
  // Assicuriamoci che QWebChannel sia disponibile
  if (typeof QWebChannel !== "undefined") {
    console.log("🚀 QWebChannel è disponibile");

    // Inizializza il WebChannel
    new QWebChannel(qt.webChannelTransport, function (channel) {
      window.bridge = channel.objects.bridge;
      console.warn("🚀 WebChannel init — bridge =", window.bridge);

      if (window.bridge) {
        console.warn("✅ Bridge disponibile!");

        // Test del bridge
        if (window.bridge.ping) {
          var pong = window.bridge.ping();
          console.warn("✅ Test ping:", pong);
        }

        if (window.bridge.onZoom) {
          console.warn("✅ Metodo bridge.onZoom disponibile");
        }
        if (window.bridge.onMapClicked) {
          console.warn("✅ Metodo bridge.onMapClicked disponibile");
        }
      } else {
        console.warn("❌ Bridge NON disponibile!");
      }

      // Registra gli eventi della mappa DOPO che il bridge è inizializzato
      map.on("click", mapClickHandler);
      map.on("zoomend", mapZoomHandler);
      map.on("moveend", mapBoundsHandler); // invia bounds anche su pan

      console.warn("✅ Eventi mappa registrati (click, zoom)");
    });
  } else {
    console.warn("❌ QWebChannel NON disponibile");
  }

  // FUNZIONE PER IL CLICK SULLA MAPPA
  function mapClickHandler(e) {
    console.warn("[DEBUG] Click event triggered");
    try {
      if (window.bridge && window.bridge.onMapClicked) {
        // Gestisce la promise restituita dal metodo
        var result = window.bridge.onMapClicked(e.latlng.lat, e.latlng.lng);
        if (result && typeof result.then === "function") {
          result.catch(function (error) {
            console.warn("❌ Errore promise click:", error);
          });
        }
      } else {
        console.warn("❌ Bridge o onMapClicked non disponibile");
      }
    } catch (error) {
      console.warn("❌ Errore nel click:", error);
    }
  }

  // FUNZIONE PER LO ZOOM DELLA MAPPA
  function mapZoomHandler() {
    console.warn("[DEBUG] Zoom event triggered");
    try {
      // Invia sempre i bounds correnti
      mapBoundsHandler();
      if (window.bridge && window.bridge.onZoom) {
        // Gestisce la promise restituita dal metodo
        var result = window.bridge.onZoom();
        if (result && typeof result.then === "function") {
          result.catch(function (error) {
            console.warn("❌ Errore promise zoom:", error);
          });
        }
      } else {
        console.warn("❌ Bridge o onZoom non disponibile");
      }
    } catch (error) {
      console.warn("❌ Errore nello zoom:", error);
    }
  }

  // FUNZIONE CHE INVIA I BOUNDS CORRENTI (usata per moveend e zoomend)
  function mapBoundsHandler() {
    try {
      if (window.bridge && window.bridge.onZoomBounds) {
        const b = map.getBounds();
        const minLat = b.getSouth();
        const maxLat = b.getNorth();
        const minLng = b.getWest();
        const maxLng = b.getEast();
        const zoomLevel = map.getZoom();
        var result = window.bridge.onZoomBounds(minLat, minLng, maxLat, maxLng, zoomLevel);
        if (result && typeof result.then === "function") {
          result.catch(function (error) {
            console.warn("❌ Errore promise bounds:", error);
          });
        }
      }
    } catch (error) {
      console.warn("❌ Errore nell'invio dei bounds:", error);
    }
  }
  console.log("✅ Global function showAnomalyPopupById registered");
}

// GESTIONE LAYER
function ADD_Layer_Survey(map) {
  var layer = window.surveyLayer;
  map.addLayer(layer);
  return layer;
}
function REMOVE_Layer_Survey(map) {
  var layer = window.surveyLayer;
  map.removeLayer(layer);
  return layer;
}

// FUNZIONE CHE ESEGUO PER INIZIALIZZARE LA PERSONALIZZAZIONE DELLA MAPPA
function initCustomFeatures(map) {
  initBridge(map); // inizializza il bridge tra js e python

  initDepthSlider(map); // inizializza lo slider della profondità

  // inizializzo la Map(dizionario) che avra come chiavi le stesse del dizionario del cache
  // e come valori l'oggetto CanvasOverlay
  window.map_dict = {};
}

// INIZIALIZZAZIONE DELLO SLIDER DELLA PROFONDITÀ
function initDepthSlider(map) {
  var depthSliderControl = L.control({ position: "topright" });

  depthSliderControl.onAdd = function (map) {
    var container = L.DomUtil.create(
      "div",
      "leaflet-bar leaflet-control leaflet-control-custom"
    );

    container.style.background = "transparent";
    container.style.border = "none";
    container.style.boxShadow = "none";
    container.style.padding = "0";
    container.style.margin = "0";

    container.innerHTML = `
            <div id="depthSliderContainer" style="
                background: rgba(50, 50, 50, 0);
                padding: 10px 8px;
                /*border-radius: 8px;*/
                width: 60px;
                height: 280px;
                display: flex;
                flex-direction: column;
                align-items: center;
                justify-content: space-between;
                /*box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);*/
            ">
                <div id="depthSliderValue" style="
                    font-size: 11px;
                    color: #f0f0f0;
                    font-weight: bold;
                ">0 cm</div>
                <input type="range" id="depthSlider" min="0" max="640" step="1" value="640"
                    style="
                        -webkit-appearance: slider-vertical;
                        appearance: slider-vertical;
                        writing-mode: vertical-lr;
                        direction: rtl;
                        height: 220px;
                        width: 20px;
                        background: #888;
                        accent-color: #7851A0;
                        cursor: pointer;
                        margin: 0;
                    ">
                <div style="
                    font-size: 11px;
                    color: #f0f0f0;
                    font-weight: bold;
                ">640 cm</div>
            </div>
        `;

    const slider = container.querySelector("#depthSlider");
    const label = container.querySelector("#depthSliderValue");

    // Mappa il valore visualizzato per avere 0 cm in alto e 640 cm in basso
    const maxDepth = 640;
    const updateDepth = () => {
      const v = parseInt(slider.value || "0");
      const depth = maxDepth - v; // inverti scala
      label.innerText = depth + " cm";
      if (window.bridge && window.bridge.onDepthChanged) {
        window.bridge.onDepthChanged(depth);
        console.warn("🔥 Chiamato onDepthChanged con", depth);
      } else {
        console.warn("⚠️ bridge.onDepthChanged non disponibile");
      }
    };
    slider.addEventListener("input", updateDepth);
    // inizializza label coerente alla posizione iniziale (maniglia in alto => 0 cm)
    setTimeout(updateDepth, 0);
    // Blocca il pan della mappa mentre il mouse è sopra lo slider
    slider.addEventListener("mouseenter", function () {
      map.dragging.disable();
      map.off("click", mapClickHandler); // Disabilita il click
      console.warn("Disabilito");
    });
    slider.addEventListener("mouseleave", function () {
      map.dragging.enable();
      map.on("click", mapClickHandler); // Riabilita il click
      console.warn("Riabilitato");
    });

    return container;
  };

  depthSliderControl.addTo(map);

  // Centra verticalmente il controllo
  setTimeout(() => {
    const container = document.querySelector(".leaflet-control-custom");
    if (container) {
      container.style.marginTop = "100px"; // centratura verticale approx
    }
  }, 100);
}

// FUNZIONE PER DISEGNARE RETTANGOLO CON CANVAS
// da rivedere questo rgbaHex
function drawTile(map, bounds, rgbaHex, width, height, zIndex = 3000) {
  function hexToU8(hex) {
    const len = hex.length / 2,
      out = new Uint8Array(len);
    for (let i = 0; i < len; i++) out[i] = parseInt(hex.substr(i * 2, 2), 16);
    return out;
  }
  const _map = map || window._leaflet_map || window.map;
  if (!_map) {
    console.error("Leaflet map not ready");
    return;
  }

  if (!window.CanvasOverlay) {
    window.CanvasOverlay = L.Layer.extend({
      initialize: function (bounds, opts) {
        this._bounds = L.latLngBounds(bounds);
        L.setOptions(this, opts);
      },
      onAdd: function (map) {
        this._map = map;
        this._canvas = L.DomUtil.create("canvas", "leaflet-canvas-layer");
        this._ctx = this._canvas.getContext("2d");
        if (this.options.zIndex != null)
          this._canvas.style.zIndex = String(this.options.zIndex);
        map.getPanes().overlayPane.appendChild(this._canvas);
        map.on("zoomend viewreset moveend resize", this._reset, this);
        this._reset();
      },
      onRemove: function (map) {
        L.DomUtil.remove(this._canvas);
        map.off("zoomend viewreset moveend resize", this._reset, this);
      },
      _reset: function () {
        const nw = this._map.latLngToLayerPoint(this._bounds.getNorthWest());
        const se = this._map.latLngToLayerPoint(this._bounds.getSouthEast());
        const size = se.subtract(nw);
        L.DomUtil.setPosition(this._canvas, nw);
        this._canvas.width = Math.max(1, Math.round(Math.abs(size.x)));
        this._canvas.height = Math.max(1, Math.round(Math.abs(size.y)));
        this._redraw();
      },
      setImageData: function (u8rgba, w, h) {
        this._imgW = w;
        this._imgH = h;
        this._u8 = u8rgba;
        this._redraw();
      },
      _redraw: function () {
        if (!this._u8 || !this._ctx || !this._canvas) return;
        const ctx = this._ctx;
        const Wc = this._canvas.width,
          Hc = this._canvas.height;
        const imgData = new ImageData(
          new Uint8ClampedArray(this._u8),
          this._imgW,
          this._imgH
        );
        const off = document.createElement("canvas");
        off.width = this._imgW;
        off.height = this._imgH;
        off.getContext("2d").putImageData(imgData, 0, 0);
        ctx.clearRect(0, 0, Wc, Hc);
        ctx.imageSmoothingEnabled = true;
        ctx.drawImage(off, 0, 0, Wc, Hc);
      },
    });
  }

  const S = bounds[0][0],
    Wlon = bounds[0][1];
  const N = bounds[1][0],
    Elon = bounds[1][1];
  const layerBounds = L.latLngBounds([S, Wlon], [N, Elon]);
  const layer = new CanvasOverlay(layerBounds, { zIndex: zIndex }).addTo(_map);
  const u8 = hexToU8(rgbaHex);
  layer.setImageData(u8, width, height);
  // devo restituire l'oggeto in modo tale che poi posso accedere all'oggetto e toglierlo/nasconderlo dalla mappa
  return layer;
}

// NUOVA FUNZIONE: disegna rettangolo a partire da una matrice di pixel
function drawSubswath(map, bounds, matrix, key, zIndex = 3000) {
  const _map = map || window._leaflet_map || window.map;
  if (!_map) {
    console.error("Leaflet map not ready");
    return;
  }

  // Assicura la presenza di CanvasOverlay (stessa implementazione di drawSubswath_old)
  if (!window.CanvasOverlay) {
    window.CanvasOverlay = L.Layer.extend({
      initialize: function (bounds, opts) {
        this._bounds = L.latLngBounds(bounds);
        L.setOptions(this, opts);
      },
      onAdd: function (map) {
        this._map = map;
        this._canvas = L.DomUtil.create("canvas", "leaflet-canvas-layer");
        this._ctx = this._canvas.getContext("2d");
        if (this.options.zIndex != null)
          this._canvas.style.zIndex = String(this.options.zIndex);
        map.getPanes().overlayPane.appendChild(this._canvas);
        map.on("zoomend viewreset moveend resize", this._reset, this);
        this._reset();
      },
      onRemove: function (map) {
        L.DomUtil.remove(this._canvas);
        map.off("zoomend viewreset moveend resize", this._reset, this);
      },
      _reset: function () {
        const nw = this._map.latLngToLayerPoint(this._bounds.getNorthWest());
        const se = this._map.latLngToLayerPoint(this._bounds.getSouthEast());
        const size = se.subtract(nw);
        L.DomUtil.setPosition(this._canvas, nw);
        this._canvas.width = Math.max(1, Math.round(Math.abs(size.x)));
        this._canvas.height = Math.max(1, Math.round(Math.abs(size.y)));
        this._redraw();
      },
      setImageData: function (u8rgba, w, h) {
        this._imgW = w;
        this._imgH = h;
        this._u8 = u8rgba;
        this._redraw();
      },
      _redraw: function () {
        if (!this._u8 || !this._ctx || !this._canvas) return;
        const ctx = this._ctx;
        const Wc = this._canvas.width,
          Hc = this._canvas.height;
        const imgData = new ImageData(
          new Uint8ClampedArray(this._u8),
          this._imgW,
          this._imgH
        );
        const off = document.createElement("canvas");
        off.width = this._imgW;
        off.height = this._imgH;
        off.getContext("2d").putImageData(imgData, 0, 0);
        ctx.clearRect(0, 0, Wc, Hc);
        ctx.imageSmoothingEnabled = true;
        ctx.drawImage(off, 0, 0, Wc, Hc);
      },
    });
  }

  // Costruzione buffer RGBA da matrice
  let width, height, u8;
  if (Array.isArray(matrix) && matrix.length > 0) {
    height = matrix.length;
    width = Array.isArray(matrix[0]) ? matrix[0].length : 0;
    if (!width) {
      console.error("Matrice non valida: prima riga vuota o non array");
      return;
    }

    // Se la matrice è 2D di numeri, normalizzo i valori finiti in [0,255]
    let minV = Infinity,
      maxV = -Infinity,
      normalize = false;
    if (typeof matrix[0][0] === "number") {
      for (let y = 0; y < height; y++) {
        const row = matrix[y];
        for (let x = 0; x < width; x++) {
          const v = row[x];
          if (typeof v === "number" && Number.isFinite(v)) {
            if (v < minV) minV = v;
            if (v > maxV) maxV = v;
          }
        }
      }
      if (Number.isFinite(minV) && Number.isFinite(maxV) && maxV > minV)
        normalize = true;
    }

    u8 = new Uint8ClampedArray(width * height * 4);
    let idx = 0;
    for (let y = 0; y < height; y++) {
      const row = matrix[y];
      for (let x = 0; x < width; x++) {
        const val = row[x];
        let r,
          g,
          b,
          a = 255;
        if (Array.isArray(val)) {
          if (val.length === 4) {
            r = val[0];
            g = val[1];
            b = val[2];
            a = val[3];
          } else if (val.length === 3) {
            r = val[0];
            g = val[1];
            b = val[2];
          } else {
            const v = Number(val);
            if (!Number.isFinite(v)) {
              r = g = b = 0;
              a = 0;
            } else {
              const gray = normalize
                ? ((v - minV) * 255) / (maxV - minV)
                : Math.max(0, Math.min(255, v));
              r = g = b = gray;
            }
          }
        } else if (typeof val === "number") {
          if (!Number.isFinite(val)) {
            r = g = b = 0;
            a = 0;
          } else {
            const gray = normalize
              ? ((val - minV) * 255) / (maxV - minV)
              : Math.max(0, Math.min(255, val));
            r = g = b = gray;
          }
        } else {
          r = g = b = 0;
          a = 0;
        }
        u8[idx++] = r | 0;
        u8[idx++] = g | 0;
        u8[idx++] = b | 0;
        u8[idx++] = a | 0;
      }
    }
  } else {
    console.error("Formato matrice non supportato");
    return;
  }

  const S = bounds[0][0],
    Wlon = bounds[0][1];
  const N = bounds[1][0],
    Elon = bounds[1][1];
  const layerBounds = L.latLngBounds([S, Wlon], [N, Elon]);
  // Se esiste già un layer con la stessa chiave, rimuovilo prima (idempotenza)
  try {
    if (window.map_dict && window.map_dict[key]) {
      _map.removeLayer(window.map_dict[key]);
    }
  } catch (e) {
    console.warn("Errore nella rimozione layer esistente:", e);
  }

  const layer = new CanvasOverlay(layerBounds, { zIndex: zIndex }).addTo(_map);
  layer.setImageData(u8, width, height);
  window.map_dict[key] = layer;
  return layer;
}

// FUNZIONE PER DISEGNARE IL CONTORNO DELLA SWATH SELEZIONATA
function drawContourSwath(map, js_coords) {
  select_swath_layer.clearLayers();

  var polygon = L.polygon(js_coords, {
    color: "#FFA500",
    weight: 2,
    fillColor: "none",
  });
  select_swath_layer.addLayer(polygon);
  polygon.bringToFront();
}

// funzione per la gestione della mia map_dict
function remove_from_map_dict(map, key) {
  // recupero l'oggetto CanvasOverlay dalla mappa
  var layer = window.map_dict[key];
  if (!layer) {
    return; // nessuna operazione se la chiave non esiste
  }
  try {
    map.removeLayer(layer);
  } catch (e) {
    console.warn("Errore rimozione layer:", e);
  }
  // cancello la chiave dal dizionario per evitare riferimenti orfani
  delete window.map_dict[key];
  //console.warn("Layer rimossa dalla mappa");
}
