# MODEL
from Model.SurveyManager import SurveyManager

import numpy as np
import time
from Algorithm.create_rastert import create_raster

class Cache:

    _instance = None

    def __new__(cls):
        if cls._instance is None:
            cls._instance = super(Cache, cls).__new__(cls)
            cls._instance._initialized = False
        return cls._instance

    
    def __init__(self):

        self.survey_manager = SurveyManager() # recupero il gestore dei survey

        if self._initialized:
            return 
        
        # KEY: "survey_id, swath_id, subswath_id, depth"
        # dizionario {"codice subswath + depth": (timestamp [array], [array_originale]), ...}
        # timestamp: ultimo aggiornamento del dato
        self.cache_dict = {}

        # costante per la dimensione del cache
        # numero di file fisso
        self.max_num_file_cache = 10000 # da capire poi 5000 - 10000
        # numero di file attuali
        self.num_file_cache = 0

        self.tomo_inferenza = False # TRUE: uso la tomografia inferenza | FALSE: uso la tomografia originale


        # query sul dizionario da 'key'-> depth -> array
        # def read(id_subswath, depth):
        #   return array

        # caso "il dizionario non ha il file"
        # 1. non c'è posto - num_file_cache_actual == max_file_cache
        #    ordino il dizionario per timestamp
        #    elimino il file più vecchio - decremento il numero di file attuali
        # vado a leggere il file e lo salvo nel dizionario -> metto il timestamp
        # incremento il numero di file attuali

        # caso "il dizionario ha il file"
        # aggiorno il timestamp
        # restuisce il file

        # print delle statistiche della cache per vedere come lavora

        self._initialized = True
    
    # AGGIORNO LA CACHE CON LE SUBSWATH ANCORA NON CARICATE, RESTITUISCO LA LISTA DELLE SUBSWATH DA DISEGNARE
    def update_cache(self, subswath_in_bounds, tomo_inferenza):
        # [(n,n,n), (n,n,n), ..., (n,n,n)] -- indicano survey, swath, subswath
        # controllo quale delle subswath non è presente nella cache
        self.tomo_inferenza = tomo_inferenza
        for subswath in subswath_in_bounds:
            id_survey, id_swath, id_subswath = subswath
            depth = self.survey_manager.get_depth()
            if f"{id_survey}_{id_swath}_{id_subswath}_{depth}" not in self.cache_dict:
                if self.num_file_cache == self.max_num_file_cache:
                    # ordino il dizionario per timestamp
                    self.cache_dict = sorted(self.cache_dict.items(), key=lambda x: x[1]["timestamp"])
                    # elimino il file più vecchio
                    self.cache_dict.pop(0)
                    self.num_file_cache -= 1

                print(f"Aggiungo il file alla cache: {id_survey}_{id_swath}_{id_subswath}_{depth}")
                y_path = self.survey_manager[id_survey][id_swath][id_subswath].path_georef_matrix_lat
                x_path = self.survey_manager[id_survey][id_swath][id_subswath].path_georef_matrix_lon
                y = np.load(y_path)
                x = np.load(x_path)
                # bounds numerici per il calcolo del raster (y0, y1, x0, x1)
                y_min, y_max = float(np.min(y)), float(np.max(y))
                x_min, x_max = float(np.min(x)), float(np.max(x))
                bounds_raster = (y_min, y_max, x_min, x_max)
                # bounds per JS (Leaflet) nel formato [[S,W],[N,E]]
                bounds_js = [[y_min, x_min], [y_max, x_max]]
                if self.tomo_inferenza:
                    tomography = self.survey_manager[id_survey][id_swath][id_subswath].tomography_inferenza(depth)
                else:
                    tomography = self.survey_manager[id_survey][id_swath][id_subswath].tomography(depth)
                start = time.time()
                raster = create_raster(tomography, x, y, self.survey_manager[id_survey][id_swath][id_subswath].path_polygon_subswath_area, splat='nearest', tomo_inferenza=self.tomo_inferenza)
                end = time.time()
                print(f"Tempo di creazione del raster: {end - start} secondi")
                self.add_file_to_cache(id_survey, id_swath, id_subswath, depth, self.survey_manager[id_survey][id_swath][id_subswath].tomography(depth), bounds_js, raster)
                self.num_file_cache += 1
                # scarico dalla memoria i file numpy
                del y, x
            else:
                self.cache_dict[f"{id_survey}_{id_swath}_{id_subswath}_{depth}"]["timestamp"] = time.time()

    def add_file_to_cache(self, id_survey, id_swath, id_subswath, depth, array, bounds, raster):
        # aggiungo il file alla cache
        self.cache_dict[f"{id_survey}_{id_swath}_{id_subswath}_{depth}"] = {
            "timestamp": time.time(),
            "array": array,
            "bounds": bounds,
            "raster": raster
        }

    def load_files_to_cache(self, id_survey, id_swath, id_subswath, depth, tomography, x, y):
        # bounds numerici per il calcolo del raster (y0, y1, x0, x1)
        y_min, y_max = float(np.min(y)), float(np.max(y))
        x_min, x_max = float(np.min(x)), float(np.max(x))
        # bounds per JS (Leaflet) nel formato [[S,W],[N,E]]
        bounds_js = [[y_min, x_min], [y_max, x_max]]
        raster = create_raster(tomography, x, y, self.survey_manager[id_survey][id_swath][id_subswath].path_polygon_subswath_area, splat='nearest', tomo_inferenza=self.tomo_inferenza)
        self.add_file_to_cache(id_survey, id_swath, id_subswath, depth, tomography, bounds_js, raster)

    def empty_cache(self):
        self.cache_dict = {}
        self.num_file_cache = 0