# MODELLO DI RAPPRESENTAZIONE DI UN SURVEY
# - Link folder swath

# MODEL
from Model.Swath import Swath

# GLOBAL
from GLOBAL import tempData

# LOGGING
import logging

import numpy as np
import os

class Survey:
    def __init__(self, original_survey_folder, ID_survey, type_survey):

        # LOGGING
        self.logger = logging.getLogger('survey_manager')

        # ID SURVEY
        self.ID_survey = ID_survey

        # FOLDER SURVEY
        self.original_survey_folder = original_survey_folder  # cartella originale del survey importato
        self.survey_name = os.path.basename(self.original_survey_folder)  # nome del survey
        self.local_survey_folder = os.path.join(tempData, self.survey_name) # cartella locale(TempData) del survey
        os.makedirs(self.local_survey_folder, exist_ok=True) # creo la cartella locale del survey

        # DATI RELATIVI AL SURVEY
        self.type_survey = type_survey
        self.type_polarization = 0  # 0 = VV, 1 = HH

        self.num_tot_swath = 0  # numero di strisciate all'interno del survey
        self.num_tot_swath_hh = 0 # numero di strisciate all'interno del survey (hh)

        self.selected_tomography = 0  # profondità della tomografia attuale
        
        # ID DEL SWATH - CHANNEL SELEZIONATO
        self.__swath_selected = 0  # di default lascio la prima swath selezionata
        self.__channel_selected = 0  # di default lascio la prima channel selezionata
        self.__depth_selected = 0 # cm 

        # INDICIZZAZIONE ID SWATH
        self.id_next_swath = 0 # id della prossima swath da creare
        self.id_next_swath_hh = 0 # id della prossima swath da creare (hh)

        # VV - LISTA OGGETTI SWATH
        self.swath_list = []  # lista che conterrà Swath [SWATH]

        # HH - LISTA OGGETTI SWATH
        self.swath_list_HH = []  # lista che conterrà Swath hh [SWATH]

        self.logger.info(f"|| Survey initialized successfully ||")
        self.logger.info(f"[SURVEY] -> ID: {self.ID_survey}")
        self.logger.info(f"[SURVEY] -> Name: {self.survey_name}")

    def __getitem__(self, index: int):
        if self.type_polarization == 0:  # 0 = VV, 1 = HH
            if self.swath_list and 0 <= index < len(self.swath_list):
                return self.swath_list[index]
            raise IndexError(f"Swath VV index {index} out of range (available: {len(self.swath_list)})")
        else:
            if self.swath_list_HH and 0 <= index < len(self.swath_list_HH):
                return self.swath_list_HH[index]
            raise IndexError(f"Swath HH index {index} out of range (available: {len(self.swath_list_HH)})")

    def ADD_SWATH(self, original_swath_path, swath_name, header_json_data, subswath_json_data, coords_perimeter, georef_matrix_lat, georef_matrix_lon):
        # AGGIUNGO SWATH
        self.logger.info(f"[SURVEY] ----------------- CREATE SWATH -----------------")
        self.logger.info(f"[SURVEY] -> Polarization: {self.type_polarization} (0 = VV | 1 = HH)")
        if self.type_polarization == 0: # SWATH VV
            new_swath = Swath(original_swath_path, swath_name, header_json_data, subswath_json_data, self.id_next_swath, self.survey_name, "VV", coords_perimeter, georef_matrix_lat, georef_matrix_lon)
            self.swath_list.append(new_swath)
            return self.id_next_swath
        else: # SWATH HH
            new_swath = Swath(original_swath_path, swath_name, header_json_data, subswath_json_data, self.id_next_swath_hh, self.survey_name, "HH", coords_perimeter, georef_matrix_lat, georef_matrix_lon)
            self.swath_list_HH.append(new_swath)
            return self.id_next_swath_hh
    def confirm_add_swath(self):
        if self.type_polarization == 0:
            self.num_tot_swath = len(self.swath_list)
            self.id_next_swath += 1
        else:
            self.num_tot_swath_hh = len(self.swath_list_HH)
            self.id_next_swath_hh += 1

    # SET PER I VARI ATTRIBUTI (DERIVATI DA INTERAZIONI) ----------------------------------------------------------------
    def set_current_depth(self, depth):
        self.selected_tomography = depth
        for swath in self.swath_list:
            swath.set_current_depth(depth)
        for swath in self.swath_list_HH:
            swath.set_current_depth(depth)
    def set_selected_swath(self, swath):
        self.__swath_selected = swath
    def set_selected_channel(self, channel):
        self.__channel_selected = channel
        if self.type_polarization == 0: # lo comunico alla swath VV
            if self.swath_list and 0 <= self.__swath_selected < len(self.swath_list):
                self.swath_list[self.__swath_selected].set_selected_channel(channel)
        else: # lo comunico alla swath HH
            if self.swath_list_HH and 0 <= self.__swath_selected < len(self.swath_list_HH):
                self.swath_list_HH[self.__swath_selected].set_selected_channel(channel)
    # ------------------------------------------------------------------------------------------------------------------

    # GET PER I VARI ATTRIBUTI (USANDO IL CURRENT SURVEY/POLARIZATION/SWATH/CHANNEL) ---------------------------------
    def get_num_tot_swath(self):
        if self.type_polarization == 0:
            return len(self.swath_list) if self.swath_list else 0
        else:
            return len(self.swath_list_HH) if self.swath_list_HH else 0
    
    def get_num_tot_ch(self):
        if self.type_polarization == 0:
            # VV: controlla che la lista non sia vuota e l'indice sia valido
            if self.swath_list and 0 <= self.__swath_selected < len(self.swath_list):
                return self.swath_list[self.__swath_selected].get_num_tot_ch()
            return 0  # Nessuna swath VV disponibile
        else:
            # HH: controlla che la lista non sia vuota e l'indice sia valido
            if self.swath_list_HH and 0 <= self.__swath_selected < len(self.swath_list_HH):
                return self.swath_list_HH[self.__swath_selected].get_num_tot_ch()
            return 0  # Nessuna swath HH disponibile
    # ------------------------------------------------------------------------------------------------------------------

    # CREAZIONE TOMOGRAFIA INFERENZA
    def create_tomography_inferenza(self):
        for swath in self.swath_list:
            swath.create_tomography_inferenza()
        # skip HH per il momento
