# CLASSE CON SINGLETON
# - Classe per la gestione dei survey importati
# - Lista dei path da dove importo i survey
# - Logger: survey_manager.log

# LOGGING
import logging

# MODELLI
from Model.Survey import Survey

class SurveyManager:
    _instance = None

    def __new__(cls):
        if cls._instance is None:
            cls._instance = super(SurveyManager, cls).__new__(cls)
            cls._instance._initialized = False
        return cls._instance

    def __init__(self):
        if self._initialized:
            return
        
        # LOGGING
        self.logger = logging.getLogger('survey_manager')

        # TOTALE DEI SURVEY IMPORTATI
        self.num_tot_import_survey = 0
        # TOTALE DEI SURVEY APERTI
        self.num_tot_open_survey = 0
        # ID DEL PROSSIMO SURVEY DA CREARE
        self.next_id_survey = 0 # id del prossimo survey da creare

        # COUNTER ADD SURVEY - SWATH - SUBSWATH
        self.current_survey = None
        self.current_swath = None
        self.current_subswath = None

        # LISTA DEGLI OGGETTI SURVEY
        self.survey_list = []  # list[Survey01, Survey02, ..., Survey0n] --> (ID survey = posizione lista)  [SURVEY]

        # ID DEL SURVEY - SWATH - CHANNEL SELEZIONATO
        self.__survey_selected = 0  # di default lascio il primo survey selezionato
        self.__swath_selected = 0  # di default lascio la prima swath selezionata
        self.__subswath_selected = 0  # di default lascio la prima subswath selezionata
        self.__channel_selected = 0  # di default lascio la prima channel selezionata
        # PROFONDITÀ CORRENTE
        self.__depth_selected = 0 # cm 

        # TIPO DI POLARIZZAZIONE
        self.__type_polarization = 0  # 0 = VV, 1 = HH

        self._initialized = True

        self.logger.info(f"|| SurveyManager initialized successfully ||")

    def __getitem__(self, index: int) -> Survey:
        self.survey_list[index].type_polarization = self.__type_polarization  # SETTA LA POLARIZZAZIONE CORRENTE AL SURVEY
        return self.survey_list[index]

    def __len__(self):
        return len(self.survey_list)

    # FUNZIONE DI AGGIUNTA (CREAZIONE DI SURVEY)
    def ADD_SURVEY(self, original_survey_folder, type_survey):
        self.logger.info(f"[SM] ----------------- CREATE SURVEY -----------------")
        self.logger.info(f"[SM] -> ID: {self.next_id_survey}")
        new_survey = Survey(original_survey_folder, self.next_id_survey, type_survey)
        self.survey_list.append(new_survey)
        # ENTRO IN MODALITA' DI AGGIUNTA SWATH (per il survey appena creato)
        self.current_survey = self.next_id_survey
    # AGGIUNTA SWATH --> SOLO SE HO AGGIUNTO UN SURVEY
    def ADD_SWATH(self, original_swath_path, swath_name, header_json_data, subswath_json_data, coords_perimeter, georef_matrix_lat, georef_matrix_lon):
        if self.current_survey is not None:
            self.logger.info(f"[SM] -> ADD SWATH --> SURVEY ID: {self.current_survey}")
            self.survey_list[self.current_survey].type_polarization = self.__type_polarization # SETTO LA POLARIZZAZIONE CORRENTE AL SURVEY
            self.current_swath = self.survey_list[self.current_survey].ADD_SWATH(original_swath_path, swath_name, header_json_data, subswath_json_data, coords_perimeter, georef_matrix_lat, georef_matrix_lon)   
        else:
            self.logger.error(f"UNEXPECTED ADD SWATH")
            raise Exception("Error: current_survey is None")
    # AGGIUNTA SUBSWATH --> SOLO SE HO AGGIUNTO UNA SWATH
    def ADD_SUBSWATH(self, info_subswath):
        self.logger.info(f"[SM] -> ADD SUBSWATH --> SURVEY ID: {self.current_survey}")
        self.logger.info(f"[SM] -> ADD SUBSWATH --> SWATH ID: {self.current_swath}")
        if self.current_survey is not None and self.current_swath is not None:
            self.survey_list[self.current_survey][self.current_swath].ADD_SUBSWATH(info_subswath)
            self.current_subswath = info_subswath['id_subswath']
        else:
            raise Exception("Error: current_survey or current_swath is None")    
    # AGGIUNTA SUBSWATH GEOREF --> SOLO SE HO AGGIUNTO UNA SUBSWATH
    def ADD_SUBSWATH_GEOREF(self, id_subswath, georef_matrix_lat, georef_matrix_lon, coords_perimeter):
        if self.current_survey is not None and self.current_swath is not None:
            self.survey_list[self.current_survey][self.current_swath][id_subswath].ADD_SUBSWATH_GEOREF(georef_matrix_lat, georef_matrix_lon, coords_perimeter)
        else:
            raise Exception("Error: current_survey or current_swath is None")
    # AGGIUNTA CHANNEL --> SOLO SE HO AGGIUNTO UNA SUBSWATH
    def ADD_SUBSWATH_CHANNEL(self, id_subswath, channel_data, name_channel):
        if self.current_survey is not None and self.current_swath is not None and self.current_subswath is not None:
            self.survey_list[self.current_survey][self.current_swath][id_subswath].ADD_SUBSWATH_CHANNEL(channel_data, name_channel)
        else:
            raise Exception("Error: current_survey or current_swath is None")
    # AGGIUNTA TOMOGRAPHY --> SOLO SE HO AGGIUNTO UNA SUBSWATH
    def ADD_SUBSWATH_TOMOGRAPHY(self, id_subswath, tomography, name_tomography):
        if self.current_survey is not None and self.current_swath is not None and self.current_subswath is not None:
            self.survey_list[self.current_survey][self.current_swath][id_subswath].ADD_SUBSWATH_TOMOGRAPHY(tomography, name_tomography)
        else:
            raise Exception("Error: current_survey or current_swath is None")

    def funct_temp_blocchettino(self, id_subswath, mat3d_sub):
        if self.current_survey is not None and self.current_swath is not None:
            self.survey_list[self.current_survey][self.current_swath][id_subswath].funct_temp_blocchettino(mat3d_sub)
        else:
            raise Exception("Error: current_survey or current_swath is None")

    def confirm_add_swath(self):
        print(f"confirm_add_swath: {self.current_swath}")
        self.survey_list[self.current_survey].confirm_add_swath()
        self.current_swath = None # tolgo la modalita' di aggiunta subswath
        self.logger.info(f"----------------- END ADD SWATH -----------------")
    def confirm_add_subswath(self):
        print(f"confirm_add_subswath: {self.current_subswath}")
        self.current_subswath = None # tolgo la modalita' di aggiunta channel
        self.logger.info(f"----------------- END ADD SUBSWATH -----------------")
    def confirm_add_survey(self):
        print(f"confirm_add_survey: {self.current_survey}")
        self.current_survey = None # tolgo la modalita' di aggiunta swath
        self.num_tot_import_survey += 1
        self.next_id_survey += 1
        self.__type_polarization = 0  # Rimetto di default VV
        self.logger.info(f"----------------- END ADD SURVEY -----------------")
    # ------------------------------------------------------------------------------------------------------------------

    # SET PER LA POLARIZZAZIONE
    def set_current_polarization(self, polarization):
        self.logger.info(f"[SET]-> Current polarization: {polarization} (0 = VV | 1 = HH)")
        self.__type_polarization = polarization
    
    # SET PER I VARI ATTRIBUTI (DERIVATI DA INTERAZIONI) ----------------------------------------------------------------
    def set_selected_survey(self, survey):
        self.__survey_selected = survey
    def set_selected_swath(self, swath):
        self.__swath_selected = swath
        self.survey_list[self.__survey_selected].set_selected_swath(swath) # lo comunico al survey selezionato
    def set_selected_subswath(self, subswath):
        self.__subswath_selected = subswath
    def set_selected_channel(self, channel):
        self.__channel_selected = channel
        self.survey_list[self.__survey_selected].set_selected_channel(channel) # lo comunico al survey selezionato
    def set_selected_depth(self, depth):
        self.__depth_selected = depth
    # ------------------------------------------------------------------------------------------------------------------

    # GET PER I VARI ATTRIBUTI (USANDO IL CURRENT SURVEY/POLARIZATION/SWATH/CHANNEL) ---------------------------------
    # numeri
    def get_id_selected_survey(self):
        return self.__survey_selected
    def get_id_selected_swath(self):
        return self.__swath_selected
    def get_id_selected_subswath(self):
        return self.__subswath_selected
    def get_id_selected_channel(self):
        return self.__channel_selected
    def get_id_selected_depth(self):
        return self.__depth_selected

    def get_num_tot_survey(self):
        return len(self.survey_list)
    def get_num_tot_swath(self):
        return self.survey_list[self.__survey_selected].get_num_tot_swath()
    def get_num_tot_subswath(self):
        return self.survey_list[self.__survey_selected][self.__swath_selected].get_num_tot_subswath()
    def get_num_tot_ch(self):
        return self.survey_list[self.__survey_selected].get_num_tot_ch()
    
    # radargramma
    def get_channel_data(self):
        return self.survey_list[self.__survey_selected][self.__swath_selected][self.__subswath_selected].channel(self.__channel_selected)
    
    # path
    def get_current_georef_folder(self):
        return self.survey_list[self.current_survey][self.current_swath][self.current_subswath].georef_polarization_folder_local
    # ------------------------------------------------------------------------------------------------------------------

    def get_depth(self):
        return self.__depth_selected

    # CREAZIONE TOMOGRAFIA INFERENZA
    def create_tomography_inferenza(self):
        for survey in self.survey_list:
            survey.create_tomography_inferenza()
