# MODELLO DI RAPPRESENTAZIONE DI UNA STRISCIATA
# - Gestione di I/O dei file .npy
# - Link file

# LOGGING
import logging

# MODEL
from Model.SubSwath import SubSwath

# GLOBAL
from GLOBAL import tempData

import numpy as np
import os
import json
import geopandas as gpd
from shapely.geometry import Polygon

class Swath:
    def __init__(self, original_swath_path, swath_name, header_json_data, subswath_json_data,
                id_swath, survey_name, type_polarization, coords_perimeter, georef_matrix_lat, georef_matrix_lon):

        # LOGGING
        self.logger = logging.getLogger('survey_manager')

        # ID SWATH
        self.ID_swath = id_swath

        # DATI RELATIVI ALLA SWATH - FOLDER 
        self.link_swath_data = original_swath_path  # cartella originale della swath
        self.swath_name = swath_name
        self.local_swath_folder = os.path.join(tempData, survey_name, self.swath_name) # cartella locale(TempData) della swath
        os.makedirs(self.local_swath_folder, exist_ok=True) # creo la cartella locale della swath se non esiste

        # TYPE POLARIZATION = "VV" o "HH" -- CREO LE CARTELLE e [JSON] Relativi alla Swath totale
        self.type_polarization = type_polarization
        self.polarization_folder_local = os.path.join(self.local_swath_folder, self.type_polarization) # cartella locale(TempData) della swath vv o hh
        os.makedirs(self.polarization_folder_local, exist_ok=True) # creo la cartella locale della swath vv o hh

        # HEADER FILE [JSON] Swath totale
        self.header_json_file = os.path.join(self.polarization_folder_local, self.swath_name + "_" + self.type_polarization + "_header_file.json")
        with open(self.header_json_file, 'w') as json_file:
            json.dump(header_json_data, json_file, indent=4)

        # CREATE ORGANIZED FILE [JSON] FOR SUBSWATH
        self.subswath_json_file = os.path.join(self.polarization_folder_local, "subSwath_organized.json")
        with open(self.subswath_json_file, 'w') as json_file:
            json.dump(subswath_json_data, json_file, indent=4)

        # COORDINATE PERIMETRO SWATH
        self.coords_perimeter = coords_perimeter
        polygon = Polygon(coords_perimeter)
        gdf = gpd.GeoDataFrame({
            'geometry': [polygon]
        })
        gdf.set_crs(epsg=32632, inplace=True)
        self.path_polygon_total_area = os.path.join(self.polarization_folder_local, "Polygon_TotalArea.json")
        gdf.to_file(self.path_polygon_total_area, driver='GeoJSON')

        # GEOREF MATRIX LAT LON SWATH
        self.path_georef_matrix_lat = os.path.join(self.polarization_folder_local, f"{self.swath_name}_lat.npy")
        self.path_georef_matrix_lon = os.path.join(self.polarization_folder_local, f"{self.swath_name}_lon.npy")
        np.save(self.path_georef_matrix_lat, georef_matrix_lat)
        np.save(self.path_georef_matrix_lon, georef_matrix_lon)

        # DATI RELATIVI AI SUBSWATH
        self.subswath_list = []

        self.num_tot_ch = header_json_data.get("channels_count", 0)

        self.logger.info(f"|| Swath initialized successfully ||")
        self.logger.info(f"[SWATH] -> ID: {self.ID_swath}")
        self.logger.info(f"[SWATH] -> Name: {self.swath_name}")
        self.logger.info(f"[SWATH] -> Polarization: {self.type_polarization} (0 = VV | 1 = HH)")

    def __getitem__(self, index: int):
        return self.subswath_list[index]

    # FUNZIONI DI AGGIUNTA: SUBSWATH, CHANNEL E TOMOGRAPHY
    def ADD_SUBSWATH(self, info_subswath):
        self.logger.info(f"[SWATH] ----------------- CREATE SUBSWATH -----------------")
        # CREO LA SUBSWATH CON LE RELATIVE INFORMAZIONI 
        new_subswath = SubSwath(info_subswath, self.polarization_folder_local)
        self.subswath_list.append(new_subswath)

    def ADD_TOMOGRAPHY(self, tomography, name_tomography):
        path_tomography = os.path.join(self.tomography_polarization_folder_local, name_tomography)
        np.save(path_tomography, tomography)

        self.link_file_tomography.append(path_tomography)
        #self.link_file_tomography_default.append(path_tomography)
        self.num_tot_tomography = len(self.link_file_tomography)

    
    # Mi restuisci il path del file .npy della tomografia alla depth selezionata(slider mappa)
    def current_depth_path_npy(self):
        return os.path.join(self.tomography_polarization_folder_local, f"depth_{self.selected_tomography:03d}cm.npy")
    def current_depth_path_geotif(self):
        return os.path.join(self.georef_polarization_folder_local, f"gpr_map_depth_{self.selected_tomography:03d}cm.tif")
    
    # SET PER I VARI ATTRIBUTI (DERIVATI DA INTERAZIONI)
    def set_current_depth(self, depth):
        self.selected_tomography = depth
    def set_selected_channel(self, channel):
        self.__channel_selected = channel
    # ------------------------------------------------------------------------------------------------------------------

    # GET PER I VARI ATTRIBUTI (USANDO IL CURRENT SURVEY/POLARIZATION/SWATH/CHANNEL) ---------------------------------
    def get_num_tot_subswath(self):
        return len(self.subswath_list)
    def get_num_tot_ch(self):
        return self.num_tot_ch
    # ------------------------------------------------------------------------------------------------------------------

    # CREAZIONE TOMOGRAFIA INFERENZA
    def create_tomography_inferenza(self):
        for subswath in self.subswath_list:
            subswath.create_tomography_inferenza()
