# CLASSE PER I TILE

import json
import os

from GLOBAL import trash_dir

class Tile:

    def __init__(self, bounds_zone, rgb):
        self.bounds_zone = bounds_zone  # contiene i 4 vertici del tile
        # [(n,n,n), (n,n,n), ..., (n,n,n)] -- indicano survey, swath, subswath
        self.all_id_subswath = []  # tiene traccia di tutte le subswath che cadono all'interno del tile
        self.rgb = rgb  # matrice 3x1
    def add_id_subswath(self, id_survey, id_swath, id_subswath):
        self.all_id_subswath.append((id_survey, id_swath, id_subswath))

    def save_point_bounds(self):
        # Salva i 4 vertici del tile come Polygon GeoJSON (EPSG:32632) nella cartella trash
        # bounds_zone contiene 4 vertici in formato (y, x) = (lat, lon) UTM metri
        # GeoJSON richiede [x, y] e l'anello deve essere chiuso (ripete il primo punto in coda)
        coords_xy = [[pt[1], pt[0]] for pt in self.bounds_zone]
        if coords_xy[0] != coords_xy[-1]:
            coords_xy.append(coords_xy[0])

        geojson = {
            "type": "FeatureCollection",
            "crs": {
                "type": "name",
                "properties": {"name": "EPSG:32632"}
            },
            "features": [
                {
                    "type": "Feature",
                    "properties": {
                        "r": self.rgb[0],
                        "g": self.rgb[1],
                        "b": self.rgb[2]
                    },
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [coords_xy]
                    }
                }
            ]
        }
        os.makedirs(trash_dir, exist_ok=True)
        with open(f"{trash_dir}/point/point_{self.rgb[0]}.geojson", "w", encoding="utf-8") as f:
            json.dump(geojson, f, indent=2, ensure_ascii=False)
        
        

        