# **XMAP - GUI per Elaborazione Dati Radar**

ULTIMO UPDATE: 06/06/2025

## **Descrizione**

XMAP è un'applicazione desktop sviluppata in Python con PySide6 (Qt) per l'elaborazione e la visualizzazione di dati radar. L'applicazione permette di importare survey, applicare filtri, visualizzare radargrammi e mappe, e gestire i dati in modo interattivo.

## **Struttura del Progetto**

```
XMAP/
├── Algorithm/                  # Algoritmi di elaborazione
│   ├── Filters/                # Filtri per i dati radar
│   │   └── OGPR_filters.py     # Implementazione dei filtri
│   └── FormatReader/           # Lettori per formati di file
│       └── OGPR.py             # Lettore per file OGPR
├── Controller/                 # Controller MVC
│   ├── Main/                   # Controller per la finestra principale
│   │   ├── MainController.py   # Gestione importazione e filtri automatici
│   │   ├── ElaborationController.py  # Gestione filtri manuali
│   │   ├── SurveyController.py # Gestione survey
│   │   ├── RadargramController.py    # Gestione radargrammi
│   │   └── MapController.py    # Gestione mappe
│   └── Start/                  # Controller per la finestra iniziale
│       └── StartController.py  # Gestione avvio applicazione
├── Logger/                     # File di log
│   ├── start.log              # Log avvio
│   ├── main.log               # Log principale
│   ├── elaboration.log        # Log elaborazione
│   ├── map.log                # Log mappe
│   ├── radargram.log          # Log radargrammi
│   └── survey.log             # Log survey
├── Model/                      # Modelli dati
│   ├── SurveyManager.py       # Gestione survey
│   ├── Survey.py              # Classe Survey
│   └── Swath.py               # Classe Swath
├── Thread/                     # Thread di elaborazione
│   ├── ApplyFilter.py         # Thread per applicazione filtri
│   └── ReadFile.py            # Thread per lettura file
├── View/                       # Interfaccia utente
│   ├── MainWindow.py          # Finestra principale
│   ├── StartWindow.py         # Finestra iniziale
│   └── ProgressBar.py         # Barra di progresso
├── Requirements/               # Dipendenze
│   └── requirements.txt       # Lista pacchetti Python
├── TempData/                   # Dati temporanei
├── XMAP.py                     # Entry point dell'applicazione
└── GLOBAL.py                   # Variabili globali
```

## **Funzionalità Principali**

- **Importazione Survey**: Caricamento di nuovi survey tramite `MainController`.
- **Elaborazione Filtri**: Applicazione automatica o manuale di filtri ai dati radar.
- **Visualizzazione Radargrammi**: Visualizzazione interattiva dei radargrammi.
- **Visualizzazione Mappe**: Visualizzazione geografica dei dati.
- **Gestione Survey**: Selezione e gestione di survey multipli.

## **Dettagli Implementativi**

- **Controller**: Gestiscono la logica di business e l'interazione tra Model e View.
- **Model**: Gestisce i dati e la logica di business (es. `SurveyManager`).
- **Thread**: Esecuzione asincrona di operazioni pesanti (es. `ApplyFilter`, `ReadFile`).
- **Logger**: Registrazione di eventi e errori per debugging.

## **Dipendenze**

Le dipendenze sono elencate in `Requirements/requirements.txt`:

```
packaging==24.2
pyqtlet==0.3.3
pyqtlet2==0.9.3
PySide6==6.9.0
PySide6_Addons==6.9.0
PySide6_Essentials==6.9.0
QtPy==2.4.3
shiboken6==6.9.0
```

## **Avvio dell'Applicazione**

L'applicazione si avvia eseguendo `XMAP.py`. Viene mostrata una finestra iniziale (`StartWindow`) per scegliere tra "Import Survey" o "Open Project". Dopo la scelta, si apre la finestra principale (`MainWindow`) con tutti i controller attivi.

## **Note Tecniche**

- **Progress Bar**: Gestita da `MainController` e `ElaborationController`. Disconnessione dei segnali per evitare conflitti.
- **Thread**: Utilizzati per operazioni asincrone (es. applicazione filtri, lettura file).
- **Logger**: Configurati per ogni componente per tracciare eventi e errori.
