# Guida: Rebuild Inference Pipeline

## Panoramica

Il sistema ora supporta il rebuild incrementale della pipeline di inferenza AI senza dover ripartire da zero. Questo permette di aggiornare i modelli AI e rigenerare solo i dati downstream.

## Funzionalità Implementate

### 1. Bottone "Rebuild with new models"

**Posizione**: Pannello "Elaboration" nella GUI principale, sotto i checkbox AI elaboration e AI Detection.

**Funzione**: Avvia il rebuild completo della pipeline di inferenza:

- Esegue `RunAI` con i nuovi modelli su `Data_current_filter`
- Rigenera tutti i tiles con i nuovi dati di inferenza
- Riprocessa multiPHT su ogni tile completato

### 2. Metadata Versione Modelli

**File salvato**: `Data_current_filter/ai_model_metadata.json` per ogni SubSwath processato

**Contenuto**:

```json
{
  "timestamp": "2025-10-27T10:30:00.123456",
  "models": {
    "longitudinale": {
      "path": "X:\\R&D\\DeepGeo\\GPRDG\\AI\\modelli\\2D_Longitudinali\\...",
      "hash": "a1b2c3d4e5f6...",
      "modified": "2025-10-20T14:22:00"
    },
    "trasversale": { ... },
    "manhole": { ... }
  }
}
```

**Utilità**:

- Traccia quale versione dei modelli è stata usata per l'inferenza
- Permette di verificare se serve un rebuild (confrontando hash)
- Logging e debugging

### 3. Metodi Controller

#### `rebuild_inference_pipeline()`

Metodo principale che coordina il rebuild:

1. Mostra progress bar
2. Disabilita bottone durante processing
3. Avvia `RunAI` con callback personalizzato
4. Al completamento AI → avvia `RunAIDetection` + `Raster_tile`
5. Al completamento tiles → mostra messaggio di successo

#### `_on_rebuild_ai_completed(message: str)`

Callback quando l'inferenza AI è completata:

- Avvia `RunAIDetection` se non in esecuzione
- Avvia `Raster_tile` per rigenerare tutti i tiles
- Ricollega handler normali

#### `_on_rebuild_tiles_completed()`

Callback quando la rigenerazione tiles è completata:

- Chiude progress bar
- Riabilita bottone
- Mostra QMessageBox di completamento

## Come Usare

### Scenario 1: Import Survey (Automatico)

1. Import survey → processo automatico come prima
2. `ReadFile` → tomografia base → signal `base_tomography_completed`
3. `RunAI` parte automaticamente e salva metadata modelli
4. Tiles e multiPHT seguono automaticamente

### Scenario 2: Rebuild con Nuovi Modelli (Manuale)

1. Modifica i percorsi dei modelli in `Thread/RunAI.py` (linee 56-58):

   ```python
   model_paths = {
       'longitudinale': r"NUOVO_PERCORSO\best_model.pth",
       'trasversale': r"NUOVO_PERCORSO\best_model.pth",
       'manhole': r"NUOVO_PERCORSO\best_model.pth"
   }
   ```

2. Nella GUI, clicca il bottone "Rebuild with new models"

3. Il sistema:

   - Rilegge `Data_current_filter` (già filtrati)
   - Applica i nuovi modelli AI
   - Sovrascrive `Data_current_filter/channel_XX.npy` con le nuove maschere
   - Salva nuovo `ai_model_metadata.json`
   - Rigenera tutti i `tiles/tile_XXXXXX/depth_XXX.npy`
   - Riprocessa multiPHT → nuovi PNG/JSON in ogni tile

4. Attendi il messaggio di completamento

### Scenario 3: Open Project

1. Apri progetto esistente
2. (Opzionale) Verifica metadata modelli in `Data_current_filter/ai_model_metadata.json`
3. Se i modelli sono cambiati, clicca "Rebuild with new models"
4. Altrimenti, usa i tiles/output esistenti

## Cosa Viene Sovrascritto

### Durante Rebuild:

✅ **Sovrascritto**:

- `Data_current_filter/channel_XX.npy` (nuove maschere AI)
- `Data_current_filter/ai_model_metadata.json` (nuovo metadata)
- `tomography_inferenza/` (se esiste, rigenerato)
- `tiles/tile_XXXXXX/depth_XXX.npy` (tutti i depth)
- `tiles/tile_XXXXXX/PNG/*.png` (tutti i plot multiPHT)
- `tiles/tile_XXXXXX/Output_JSON/*.json` (statistiche e geometrie)
- `tiles/tile_XXXXXX/multipht_acc.npy` (accumulatore PHT)

❌ **NON Toccato**:

- Dati raw OGPR
- `Data/` (canali originali non filtrati)
- Tomografia base in `tomography/`
- Bounds/geometria tiles (non ridefiniti)
- Altri file di configurazione survey

## Testing

### Test Manuale

1. **Test 1: Rebuild dopo Import**

   - Import survey normalmente
   - Attendi completamento automatico
   - Modifica percorso modello in `RunAI.py`
   - Clicca "Rebuild with new models"
   - Verifica:
     - Progress bar appare
     - Log mostra "=== REBUILD INFERENCE PIPELINE STARTED ==="
     - Tutti i tiles vengono rigenerati
     - Messaggio di successo appare
     - `ai_model_metadata.json` aggiornato con nuovi hash

2. **Test 2: Open Project + Rebuild**

   - Apri progetto esistente
   - Clicca "Rebuild with new models"
   - Verifica come sopra

3. **Test 3: Verifica Metadata**
   - Dopo rebuild, controlla `Data_current_filter/ai_model_metadata.json`
   - Verifica timestamp recente
   - Verifica hash modelli corrispondono ai file effettivi

### Test di Regressione

- ✅ Import survey normale (senza rebuild) funziona come prima
- ✅ Open project senza rebuild carica dati esistenti
- ✅ Checkbox AI elaboration/detection funzionano indipendentemente
- ✅ Filtri manuali non interferiscono con rebuild

## Note Implementative

### Thread Management

- `RunAI`: Singleton, riavviabile
- `RunAIDetection`: Singleton, resta in ascolto (event loop)
- `Raster_tile`: Singleton, riavviabile
- Signal/slot temporanei per rebuild, poi ripristinati a handler normali

### Error Handling

- Try-catch su ogni step
- Progress bar chiusa anche in caso di errore
- Bottone riabilitato su errore
- Log dettagliati per debugging

### Performance

- No rilettura OGPR (usa `Data_current_filter` già esistenti)
- No ricalcolo bounds/griglia tiles
- Parallelizzazione tile processing via `RunAIDetection`

## File Modificati

1. **View/MainWindow.py**

   - Aggiunto `btn_rebuild_inference` con styling

2. **Controller/Main/ElaborationController.py**

   - `_connect_rebuild_inference_button()`
   - `rebuild_inference_pipeline()`
   - `_on_rebuild_ai_completed()`
   - `_on_rebuild_tiles_completed()`

3. **Thread/RunAI.py**
   - Calcolo metadata modelli (hash MD5, timestamp)
   - Salvataggio `ai_model_metadata.json`

## Future Improvements

### Possibili Estensioni:

1. **Rebuild Incrementale per Tile**

   - Confronta hash metadata tile-by-tile
   - Rigenera solo tiles modificati

2. **UI Model Selector**

   - Dropdown per selezionare modelli da GUI
   - Validazione percorsi prima di rebuild

3. **Diff Visualization**

   - Mostra differenze tra output vecchio/nuovo
   - Side-by-side comparison PNG

4. **Automatic Rebuild Detection**

   - All'apertura progetto, rileva cambio modelli
   - Prompt automatico per rebuild se necessario

5. **Rollback Capability**
   - Backup tiles precedenti prima di rebuild
   - Bottone "Restore previous version"

## Supporto

Per problemi o domande:

- Controlla log in `Logger/elaboration.log`
- Verifica metadata in `Data_current_filter/ai_model_metadata.json`
- Controlla print debug in console durante rebuild

## Changelog

### v1.0 (2025-10-27)

- ✅ Implementato bottone "Rebuild with new models"
- ✅ Metadata versione modelli AI
- ✅ Pipeline rebuild completo (RunAI → Raster_tile → RunAIDetection)
- ✅ Progress bar e feedback utente
- ✅ Error handling robusto
