# IMPORT PYSIDE6
from PySide6.QtCore import QThread, Signal

import os
import numpy as np
import logging

from GLOBAL import *

# MODEL
from Model.TileManager import TileManager



# Thread per la rendering delle subswath
class Raster_tile(QThread):
    _instance = None  # Qui memorizziamo l'unica istanza

    def __new__(cls):
        if cls._instance is None:
            cls._instance = super(Raster_tile, cls).__new__(cls)
            cls._instance._initialized = False
        return cls._instance

    raster_tile_completed = Signal()
    tile_completed = Signal(int, str, int)  # tile_id, out_dir, expected_depth

    def __init__(self, parent=None):
        # Evita la doppia inizializzazione del QThread
        if hasattr(self, '_initialized') and self._initialized:
            return
            
        super().__init__(parent)
        self._initialized = True

        self.tile_manager = TileManager()  # recupero il gestore dei tile

    def run(self):
        print("[Raster_tile] Avvio generazione raster tiles...")
        def on_tile_completed(tile_id: int, out_dir: str, expected_depth: int):
            try:
                print(f"[Raster_tile] Emetto signal tile_completed per tile {tile_id}")
                self.tile_completed.emit(int(tile_id), str(out_dir), int(expected_depth))
                print(f"[Raster_tile] Signal emesso per tile {tile_id}")
            except Exception as e:
                print(f"[Raster_tile] Errore emissione signal tile {tile_id}: {e}")
        
        print("[Raster_tile] Chiamo tile_manager.create_volume_raster...")
        self.tile_manager.create_volume_raster(on_tile_completed=on_tile_completed)
        print("[Raster_tile] Generazione raster completata, emetto raster_tile_completed")
        self.raster_tile_completed.emit()
        print("[Raster_tile] END")
        



