# IMPORT PYSIDE6
from PySide6.QtCore import QThread, Signal

import os
import numpy as np
import logging
import shutil
import time

# ALGORITHM
from Algorithm.split_swath import split_swath
from Algorithm.FormatReader.OGPR import *

from GLOBAL import *

# MODEL
from Model.SurveyManager import SurveyManager
from Model.ProjectManifest import write_tempdata_manifest

# Thread per la lettura del file
class ReadFile(QThread):
    _instance = None  # Qui memorizziamo l'unica istanza

    def __new__(cls):
        if cls._instance is None:
            cls._instance = super(ReadFile, cls).__new__(cls)
            cls._instance._initialized = False
        return cls._instance

    # Signal per segnalare i controller
    finish_read = Signal(bool)
    base_tomography_completed = Signal()

    def __init__(self, parent=None):
        # Evita la doppia inizializzazione del QThread
        if hasattr(self, '_initialized') and self._initialized:
            return
            
        super().__init__(parent)
        self._initialized = True

        self.original_survey_folder = None
        self.survey_manager = SurveyManager()  # recupero il gestore dei survey
        self.start_logger = logging.getLogger('start')

    def run(self):
        self.start_logger.info(f"//////////////////////////// SURVEY FOLDER: {self.original_survey_folder} ////////////////////////////")
        if self.original_survey_folder:

            # DECISIONE TIPOLOGIA FILE RADAR
            typology = None

            # CHECK OGPR
            all_files = os.listdir(self.original_survey_folder)
            if all(f.endswith(".ogpr") for f in all_files):
                typology = "OGPR"

            # CHECK VOL

            # CHECK DZT

            # Dizionario che simula lo switch-case
            dispatch = {
                "OGPR": self.read_ogpr,
            }
            if typology in dispatch:
                # print(f"Eseguo tipo: {typology}")
                self.start_logger.info(f"Exec type survey: {typology}")
                try:
                    dispatch[typology]()
                    typology = True
                except Exception as e:
                    # self.survey_manager.
                    self.start_logger.error(f"Error read file: {e}")
                    # print("Errore nella lettura del file")
                    typology = False
            else:
                # print(f"Tipologia '{typology}' non riconosciuta")
                self.start_logger.info(f"Typology not correct")
                typology = False

            self.finish_read.emit(typology)
        else:
            self.finish_read.emit(False)
        self.start_logger.info(f"//////////////////////////////////////// COMPLETED ////////////////////////////////////////")

    def read_ogpr(self):

        # MAX E MIN PER CREARE I TILES
        max_lon = None
        min_lon = None
        max_lat = None
        min_lat = None

        # CREO IL SURVEY
        self.start_logger.info(f"----------------- ADD SURVEY -----------------")
        self.start_logger.info(f"-> Survey folder: {self.original_survey_folder}")
        self.survey_manager.ADD_SURVEY(self.original_survey_folder, "OGPR")

        # Elenco dei file .ogpr nella cartella, ordinati alfabeticamente
        all_ogrp_files = os.listdir(self.original_survey_folder)
        ogpr_files = []
        for file in all_ogrp_files:
            if file.endswith('.ogpr'):
                ogpr_files.append(file)
        del all_ogrp_files
        ogpr_files.sort()  # Ordina alfabeticamente

        is_hh_found = True
        # Controllo se i primi due file hanno lo stesso nome swath con Array01 e Array02
        if len(ogpr_files) >= 2:
            first_swath = ogpr_files[0].split("_Array")[0]
            second_swath = ogpr_files[1].split("_Array")[0]
            # Se sono swath diverse, aggiungo un file fittizio vuoto per mantenere il ciclo
            if first_swath != second_swath:
                # Devo simulare l'esistenza di un file HH per mantenere il ciclo
                new_list = []
                for file in ogpr_files:
                    new_list.append(file)
                    new_list.append(file) 
                ogpr_files = new_list
                self.start_logger.info(f"[ALERT] NO HH FILE FOUND")
                is_hh_found = False


        # Assumendo che i file siano ordinati: VV1, HH1, VV2, HH2, ... oppure VV1, "", VV2, "", ...
        for vv_ogpr, hh_ogpr in zip(ogpr_files[::2], ogpr_files[1::2]):
            self.start_logger.info(f"################# ADD SWATH VV #################")
            self.start_logger.info(f"-> VV: {vv_ogpr}, HH: {hh_ogpr}")

            # NOME DELLA SWATH (VV E HH)
            name_swath = vv_ogpr.split("_Array")[0]  # Swath01, Swath02, ...
            self.start_logger.info(f"-> NAME SWATH: {name_swath}")

            # DATA VV ------------------------------------------------------------------------------------------------------
            ogpr_path_vv = os.path.join(self.original_survey_folder, vv_ogpr)
            self.start_logger.info(f"-> Processing swath VV: {ogpr_path_vv}")

            # ESTRAZIONE DATI JSON HEADER VV
            header_json_data = extract_header_ogpr(ogpr_path_vv)
            # Estrai dati dal JSON header VV
            num_channels = header_json_data.get("channels_count", 0)
            byte_offset = header_json_data.get("byte_offset_data", 0)
            byte_size = header_json_data.get("byte_size_data", 0)
            sample_count = header_json_data.get("sample_count", 0)  # 1024 profondità
            sample_count_original = sample_count  # Preserva il valore originale per la lettura dei dati binari
            slices_count = header_json_data.get("slices_count", 0)  # 436 x
            byte_size_georef = header_json_data.get("byte_size_georef", 0)
            byte_offset_georef = header_json_data.get("byte_offset_georef", 0)

            if slices_count < 30:
                self.start_logger.info(f"[CONTINUE] Slices count is less than 5 -- Next file ...")
                continue

            # COSTRUISCO LA MIA SWATH DA AGGIUNGERE AL SURVEY
            self.start_logger.info(f"-> Set polarization: 0 (0 = VV | 1 = HH)")
            self.survey_manager.set_current_polarization(0) # type_polarization = 0  # VV
            self.start_logger.info(f"-> Preparing division of swath ...")
            # CREAZIONE JSON PER COORDINARE I SUBSWATH
            blocks = split_swath(slices_count)
            self.start_logger.info(f" -> Num Blocks subswath: {len(blocks)}")
            subswath_json_data = create_json_subswath(blocks)
            # POLYGON AREA SWATH -- JSON FILE
            depth, georef_matrix_lat, georef_matrix_lon, coords_perimeter = extract_swath_gps_ogpr(ogpr_path_vv, header_json_data)
            depth = depth * (-1) # porto la profondita in positivo
            max_depth_cm = int(depth * 100) # porto la profondita in centimetri
            target_depths_cm = np.arange(0, max_depth_cm + 1)  # da 0 a N cm
            if max_lat is None or max_lat < np.nanmax(georef_matrix_lat):
                max_lat = np.nanmax(georef_matrix_lat)
            if min_lat is None or min_lat > np.nanmin(georef_matrix_lat):
                min_lat = np.nanmin(georef_matrix_lat)
            if max_lon is None or max_lon < np.nanmax(georef_matrix_lon):
                max_lon = np.nanmax(georef_matrix_lon)
            if min_lon is None or min_lon > np.nanmin(georef_matrix_lon):
                min_lon = np.nanmin(georef_matrix_lon)
            # CREO LA SWATH
            self.survey_manager.ADD_SWATH(ogpr_path_vv, name_swath, header_json_data, subswath_json_data, coords_perimeter, georef_matrix_lat, georef_matrix_lon)  

            # AGGIUNGO LE SUBSWATH 
            for info_subswath in subswath_json_data["subswath_details"]:
                self.start_logger.info(f"----------------- ADD SUBSWATH -----------------")
                self.survey_manager.ADD_SUBSWATH(info_subswath)

                start_idx = info_subswath["start_index"]
                end_idx = info_subswath["end_index"]

                mat3d_sub = extract_subswath(ogpr_path_vv, start_idx, end_idx, byte_offset, sample_count_original, num_channels)
                # TEMP ##############
                self.survey_manager.funct_temp_blocchettino(info_subswath['id_subswath'],mat3d_sub) 
                # TEMP ##############
                subswath_georef_matrix_lat, subswath_georef_matrix_lon, subswath_coords_perimeter = extract_subswath_swath_gps_ogpr(ogpr_path_vv, header_json_data, start_idx, end_idx)
                self.survey_manager.ADD_SUBSWATH_GEOREF(info_subswath['id_subswath'], subswath_georef_matrix_lat, subswath_georef_matrix_lon, subswath_coords_perimeter)
                
                # CHANNEL SUBSWATH
                self.start_logger.info(f"[ADD CHANNEL] ---> subswath_{info_subswath['id_subswath']:02d}_channel_00")
                self.start_logger.info(f"[ADD CHANNEL] ---> ...")
                for ch in range(num_channels):
                    data_channel = mat3d_sub[:, ch, :].T
                    name_channel = f"subswath_{info_subswath['id_subswath']:02d}_channel_{ch:02d}"
                    self.survey_manager.ADD_SUBSWATH_CHANNEL(info_subswath['id_subswath'], data_channel, name_channel)

                    # SALVO IL RADARGRAMMA COME IMMAGINE NELLA CARTELLA TRASH
                    if False:
                        try:
                            # Normalizza l'array a 8-bit unsigned integer (0-255)
                            normalized = np.interp(data_channel, (data_channel.min(), data_channel.max()), (0, 255))
                            img_array = normalized.astype(np.uint8)
                            # Crea l'immagine
                            from PIL import Image
                            img = Image.fromarray(img_array, mode='L')  # 'L' mode for grayscale
                            img_path = os.path.join(trash_dir, f"subswath_{info_subswath['id_subswath']:02d}_channel_{ch:02d}.png")
                            img.save(img_path)
                            #self.start_logger.info(f"[SAVE] ---> Saved subswath image: {img_path}")
                        except Exception as e:
                            self.start_logger.error(f"Error saving subswath image: {str(e)}")
                            continue
                self.start_logger.info(f"[ADD CHANNEL] ---> subswath_{info_subswath['id_subswath']:02d}_channel_{ch:02d}")

                # APPLICO I FILTRI AUTOMATICAMENTE >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                # Applicazione automatica dei filtri nell'ordine: start time shifter, passabanda, rimozione rumore di fondo, gain
                from Algorithm.Filters.OGPR_filters import start_time_shifterOGPR, bandpass_fir, background_removal, gain
                channel_list = [] # conterrà i canali con i filtri applicati | li metto in una lista perche potrebbero non avere le stesse dimensioni
                # Applica i filtri a tutti i canali del cubetto 3D
                self.start_logger.info(f"[APPLY FILTERS] ---> APPLICO I FILTRI")
                for ch in range(num_channels):
                    # Estrai il canale corrente dal cubetto 3D: mat3d_sub è (num_slices, channels_count, sample_count)
                    data_channel = mat3d_sub[:, ch, :]  # Ottieni (num_slices, sample_count)
                    
                    # 1. Start time shifter (può cambiare le dimensioni)
                    # NOTA: start_time_shifterOGPR si aspetta (ntraces, nsamples) = (sample_count, num_slices)
                    # Dobbiamo trasporre per far modificare la dimensione corretta (campioni invece di tracce)
                    data_channel = data_channel.T  # (sample_count, num_slices) - trasponiamo
                    data_channel = start_time_shifterOGPR(data_channel)  
                    # 2. Filtro passa-banda (150-850 MHz, order=71) - stessi parametri GUI
                    data_channel = bandpass_fir(data_channel, dt_ns=0.125, fmin_mhz=150, fmax_mhz=850, order=71)
                    # 3. Rimozione rumore di fondo (window_traces=0) - stesso parametro GUI
                    data_channel = background_removal(data_channel, window_traces=0)
                    # 4. Gain
                    data_channel = gain(data_channel)                    
                    channel_list.append(data_channel)
                
                # controllo qual è il canale con le dimensioni maggiori (sia righe che colonne)
                # poi ricostruisco una mat3d_sub con le dimesioni nuove e aggiungo dei valori a 0 la dove le matrici sono minori alla maggiore
                max_rows = max(channel_list, key=lambda x: x.shape[0]).shape[0]
                max_cols = max(channel_list, key=lambda x: x.shape[1]).shape[1]
                
                # creo la matrice 3D con le dimensioni massime trovate
                mat3d_sub = np.zeros((max_cols, num_channels, max_rows))

                self.start_logger.info(f"[SUBSWATH] -> Mat3d sub shape: {mat3d_sub.shape}")
                
                # per ogni canale, posiziono la matrice nell'angolo in alto a sinistra e riempio il resto con zeri
                for ch in range(num_channels):
                    current_channel = channel_list[ch]
                    current_channel = current_channel.T
                    rows, cols = current_channel.shape
                    # posiziono la matrice nell'angolo in alto a sinistra
                    mat3d_sub[:rows, ch, :cols] = current_channel
                # aggiorno sample_count con le nuove dimensioni
                sample_count = mat3d_sub.shape[2]

                # SALVO I DATI FILTRATI IN Data_current_filter PER L'AI
                self.start_logger.info(f"[SAVE FILTERED DATA] ---> Salvo dati filtrati in Data_current_filter")
                for ch in range(num_channels):
                    filtered_channel = channel_list[ch]  # Dati già filtrati
                    channel_filename = f"channel_{ch:02d}.npy"
                    channel_path = os.path.join(self.survey_manager[0][self.survey_manager.current_swath][info_subswath['id_subswath']].data_current_filter_folder, channel_filename)
                    np.save(channel_path, filtered_channel)
                    self.start_logger.info(f"[SAVE FILTERED DATA] ---> Salvato: {channel_filename}")

                # TOMOGRAPHY SUBSWATH
                self.start_logger.info(f"[ADD TOMOGRAPHY] ---> depth_000cm.npy")
                self.start_logger.info(f"[ADD TOMOGRAPHY] ---> ...")
                for z in range(len(target_depths_cm)):
                    depth_m = target_depths_cm[z] / 100.0  # converti cm in metri
                    z_original = int(depth_m * (sample_count / depth))
                    if z_original >= sample_count:
                        z_original = sample_count - 1
                    tomography = mat3d_sub[:, :, z_original].T # Carico la tomografia all'indice relativo alla profondità
                    name_tomography = f"depth_{z:03d}cm"
                    self.survey_manager.ADD_SUBSWATH_TOMOGRAPHY(info_subswath['id_subswath'], tomography, name_tomography)

                    # SALVO IL RADARGRAMMA COME IMMAGINE NELLA CARTELLA TRASH
                    if False:
                        try:
                            # Normalizza l'array a 8-bit unsigned integer (0-255)
                            normalized = np.interp(tomography, (tomography.min(), tomography.max()), (0, 255))
                            img_array = normalized.astype(np.uint8)
                            # Crea l'immagine
                            from PIL import Image
                            img = Image.fromarray(img_array, mode='L')  # 'L' mode for grayscale
                            img_path = os.path.join(trash_dir, name_tomography.replace(".npy", ".png"))
                            img.save(img_path)
                            #self.start_logger.info(f"[SAVE] ---> Saved tomography image: {img_path}")
                        except Exception as e:
                            self.start_logger.error(f"Error saving tomography image: {str(e)}")
                            continue
                self.start_logger.info(f"[ADD TOMOGRAPHY] ---> depth_{z:03d}.npy")

                self.survey_manager.confirm_add_subswath()
                self.start_logger.info(f"[COMPLETED] SubSwath_{info_subswath['id_subswath']:02d} completed")
                time.sleep(0.2)

            self.survey_manager.confirm_add_swath()
            self.start_logger.info(f"[COMPLETED] Swath: {name_swath} completed")
            print("STOOOOOOOOOOOP FINE VV")

            
            
            
            
            if not is_hh_found:
                self.start_logger.info(f"[CONTINUE] No HH file found -- Next swath ...")
                continue
            # DATA HH ------------------------------------------------------------------------------------------------------
            self.start_logger.info(f"################# ADD SWATH HH #################")
            ogpr_path_hh = os.path.join(self.original_survey_folder, hh_ogpr)
            self.start_logger.info(f"-> Processing swath HH: {ogpr_path_hh}")

            # ESTRAZIONE DATI JSON HEADER HH
            header_json_data = extract_header_ogpr(ogpr_path_hh)
            # Estrai dati dal JSON header HH
            num_channels = header_json_data.get("channels_count", 0)
            byte_offset = header_json_data.get("byte_offset_data", 0)
            byte_size = header_json_data.get("byte_size_data", 0)
            sample_count = header_json_data.get("sample_count", 0)  # 1024 profondità
            sample_count_original = sample_count  # Preserva il valore originale per la lettura dei dati binari
            slices_count = header_json_data.get("slices_count", 0)  # 436 x
            byte_size_georef = header_json_data.get("byte_size_georef", 0)
            byte_offset_georef = header_json_data.get("byte_offset_georef", 0)

            # COSTRUISCO LA MIA SWATH DA AGGIUNGERE AL SURVEY
            self.start_logger.info(f"-> Set polarization: 1 (0 = VV | 1 = HH)")
            self.survey_manager.set_current_polarization(1) # type_polarization = 1  # HH
            self.start_logger.info(f"-> Preparing division of swath ...")
            # CREAZIONE JSON PER COORDINARE I SUBSWATH
            blocks = split_swath(slices_count)
            self.start_logger.info(f" -> Num Blocks subswath: {len(blocks)}")
            subswath_json_data = create_json_subswath(blocks)
            # POLYGON AREA SWATH -- JSON FILE
            depth, georef_matrix_lat, georef_matrix_lon, coords_perimeter = extract_swath_gps_ogpr(ogpr_path_hh, header_json_data)
            depth = depth * (-1) # porto la profondita in positivo
            max_depth_cm = int(depth * 100) # porto la profondita in centimetri
            target_depths_cm = np.arange(0, max_depth_cm + 1)  # da 0 a N cm
            # CREO LA SWATH
            self.survey_manager.ADD_SWATH(ogpr_path_hh, name_swath, header_json_data, subswath_json_data, coords_perimeter, georef_matrix_lat, georef_matrix_lon)  
 
            # AGGIUNGO LE SUBSWATH 
            for info_subswath in subswath_json_data["subswath_details"]:
                self.start_logger.info(f"----------------- ADD SUBSWATH -----------------")
                self.survey_manager.ADD_SUBSWATH(info_subswath)

                start_idx = info_subswath["start_index"]
                end_idx = info_subswath["end_index"]

                mat3d_sub = extract_subswath(ogpr_path_hh, start_idx, end_idx, byte_offset, sample_count_original, num_channels)
  
                # CHANNEL SUBSWATH
                self.start_logger.info(f"[ADD] ---> subswath_{info_subswath['id_subswath']:02d}_channel_00")
                self.start_logger.info(f"[ADD] ---> ...")
                for ch in range(num_channels):
                    data_channel = mat3d_sub[:, ch, :].T
                    name_channel = f"subswath_{info_subswath['id_subswath']:02d}_channel_{ch:02d}"
                    self.survey_manager.ADD_SUBSWATH_CHANNEL(info_subswath['id_subswath'], data_channel, name_channel)

                    # SALVO IL RADARGRAMMA COME IMMAGINE NELLA CARTELLA TRASH
                    if False:
                        try:
                            # Normalizza l'array a 8-bit unsigned integer (0-255)
                            normalized = np.interp(data_channel, (data_channel.min(), data_channel.max()), (0, 255))
                            img_array = normalized.astype(np.uint8)
                            # Crea l'immagine
                            from PIL import Image
                            img = Image.fromarray(img_array, mode='L')  # 'L' mode for grayscale
                            img_path = os.path.join(trash_dir, f"subswath_{info_subswath['id_subswath']:02d}_channel_{ch:02d}.png")
                            img.save(img_path)
                            self.start_logger.info(f"[SAVE] ---> Saved subswath image: {img_path}")
                        except Exception as e:
                            self.start_logger.error(f"Error saving subswath image: {str(e)}")
                            continue
                self.start_logger.info(f"[ADD] ---> subswath_{info_subswath['id_subswath']:02d}_channel_{ch:02d}")

                # APPLICO I FILTRI AUTOMATICAMENTE >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                # Applicazione automatica dei filtri nell'ordine: start time shifter, passabanda, rimozione rumore di fondo, gain
                from Algorithm.Filters.OGPR_filters import start_time_shifterOGPR, bandpass_fir, background_removal, gain
                channel_list = [] # conterrà i canali con i filtri applicati | li metto in una lista perche potrebbero non avere le stesse dimensioni
                # Applica i filtri a tutti i canali del cubetto 3D
                self.start_logger.info(f"[APPLY FILTERS] ---> APPLICO I FILTRI")
                for ch in range(num_channels):
                    # Estrai il canale corrente dal cubetto 3D: mat3d_sub è (num_slices, channels_count, sample_count)
                    data_channel = mat3d_sub[:, ch, :]  # Ottieni (num_slices, sample_count)
                    
                    # 1. Start time shifter (può cambiare le dimensioni)
                    # NOTA: start_time_shifterOGPR si aspetta (ntraces, nsamples) = (sample_count, num_slices)
                    # Dobbiamo trasporre per far modificare la dimensione corretta (campioni invece di tracce)
                    data_channel = data_channel.T  # (sample_count, num_slices) - trasponiamo
                    data_channel = start_time_shifterOGPR(data_channel)  
                    # 2. Filtro passa-banda (150-850 MHz, order=71) - stessi parametri GUI
                    data_channel = bandpass_fir(data_channel, dt_ns=0.125, fmin_mhz=150, fmax_mhz=850, order=71)
                    # 3. Rimozione rumore di fondo (window_traces=0) - stesso parametro GUI
                    data_channel = background_removal(data_channel, window_traces=0)
                    # 4. Gain
                    data_channel = gain(data_channel)                    
                    channel_list.append(data_channel)
                
                # controllo qual è il canale con le dimensioni maggiori (sia righe che colonne)
                # poi ricostruisco una mat3d_sub con le dimesioni nuove e aggiungo dei valori a 0 la dove le matrici sono minori alla maggiore
                max_rows = max(channel_list, key=lambda x: x.shape[0]).shape[0]
                max_cols = max(channel_list, key=lambda x: x.shape[1]).shape[1]
                
                # creo la matrice 3D con le dimensioni massime trovate
                mat3d_sub = np.zeros((max_cols, num_channels, max_rows))
                
                # per ogni canale, posiziono la matrice nell'angolo in alto a sinistra e riempio il resto con zeri
                for ch in range(num_channels):
                    current_channel = channel_list[ch]
                    current_channel = current_channel.T
                    rows, cols = current_channel.shape
                    # posiziono la matrice nell'angolo in alto a sinistra
                    mat3d_sub[:rows, ch, :cols] = current_channel
                # aggiorno sample_count con le nuove dimensioni
                sample_count = mat3d_sub.shape[2]

                # SALVO I DATI FILTRATI IN Data_current_filter PER L'AI (HH)
                self.start_logger.info(f"[SAVE FILTERED DATA HH] ---> Salvo dati filtrati in Data_current_filter")
                for ch in range(num_channels):
                    filtered_channel = channel_list[ch]  # Dati già filtrati
                    channel_filename = f"channel_{ch:02d}.npy"
                    channel_path = os.path.join(self.survey_manager[0][self.survey_manager.current_swath][info_subswath['id_subswath']].data_current_filter_folder, channel_filename)
                    np.save(channel_path, filtered_channel)
                    self.start_logger.info(f"[SAVE FILTERED DATA HH] ---> Salvato: {channel_filename}")

                # TOMOGRAPHY SUBSWATH
                self.start_logger.info(f"[ADD TOMOGRAPHY] ---> depth_000cm.npy")
                self.start_logger.info(f"[ADD TOMOGRAPHY] ---> ...")
                for z in range(len(target_depths_cm)):
                    depth_m = target_depths_cm[z] / 100.0  # converti cm in metri
                    z_original = int(depth_m * (sample_count / depth))
                    if z_original >= sample_count:
                        z_original = sample_count - 1
                    tomography = mat3d_sub[:, :, z_original] # Carico la tomografia all'indice relativo alla profondità
                    name_tomography = f"depth_{z:03d}cm.npy"
                    self.survey_manager.ADD_SUBSWATH_TOMOGRAPHY(info_subswath['id_subswath'], tomography, name_tomography) 

                    if False:
                        try:
                            # Normalizza l'array a 8-bit unsigned integer (0-255)
                            normalized = np.interp(tomography, (tomography.min(), tomography.max()), (0, 255))
                            img_array = normalized.astype(np.uint8)
                            # Crea l'immagine
                            from PIL import Image
                            img = Image.fromarray(img_array, mode='L')  # 'L' mode for grayscale
                            img_path = os.path.join(trash_dir, name_tomography.replace(".npy", ".png"))
                            img.save(img_path)
                            #self.start_logger.info(f"[SAVE] ---> Saved tomography image: {img_path}")
                        except Exception as e:
                            self.start_logger.error(f"Error saving tomography image: {str(e)}")
                            continue

                self.start_logger.info(f"[COMPLETED] SubSwath_{info_subswath['id_subswath']:02d} completed")
                self.survey_manager.confirm_add_subswath()

            self.survey_manager.confirm_add_swath()

            print("STOOOOOOOOOOOP FINE HH")
            # --------------------------------------------------------------------------------------------------------------
        # UNA VOLTA FINITO DI COSTRUIRE IL MIO SURVEY CONFERMO AL MANAGER
        self.survey_manager.confirm_add_survey()
        self.start_logger.info(f"----------------- END ADD SURVEY -----------------")

        # CREAZIONE TILES
        self.start_logger.info(f"----------------- CREATE TILES -----------------")
        from Model.TileManager import TileManager
        tile_manager = TileManager()
        self.start_logger.info(f"-> Set bounds zone: {max_lon}, {min_lon}, {max_lat}, {min_lat}")
        tile_manager.set_bounds_zone(max_lon, min_lon, max_lat, min_lat)

        # EMETTO IL SIGNAL DI COMPLETAMENTO TOMOGRAPHY BASE
        self.start_logger.info(f"----------------- BASE TOMOGRAPHY COMPLETED - TRIGGERING AI -----------------")
        print("[DEBUG] Emitting base_tomography_completed signal")
        self.base_tomography_completed.emit()
        print("[DEBUG] Signal emitted successfully")

        # WRITE MANIFEST FOR QUICK REOPEN
        try:
            manifest_path = write_tempdata_manifest(tempData, self.survey_manager)
            self.start_logger.info(f"[MANIFEST] TempData manifest written: {manifest_path}")
        except Exception as e:
            self.start_logger.error(f"[MANIFEST] Error writing TempData manifest: {e}")


        

