# IMPORT PYSIDE6
from PySide6.QtCore import QThread, Signal

import os
import numpy as np
import logging

from GLOBAL import *

# MODEL
from Model.SurveyManager import SurveyManager
from Model.TileManager import TileManager
from Model.Cache import Cache

from Thread.Raster_tile import Raster_tile

# Thread per la rendering delle subswath
class Rendering(QThread):
    _instance = None  # Qui memorizziamo l'unica istanza

    def __new__(cls):
        if cls._instance is None:
            cls._instance = super(Rendering, cls).__new__(cls)
            cls._instance._initialized = False
        return cls._instance

    # Signal per segnalare l'aggiornamento sulla mappa
    update_map = Signal()

    raster_tile_completed = Signal()

    def __init__(self, parent=None):
        # Evita la doppia inizializzazione del QThread
        if hasattr(self, '_initialized') and self._initialized:
            return
            
        super().__init__(parent)
        self._initialized = True

        self.tile_manager = TileManager()  # recupero il gestore dei tile
        self.survey_manager = SurveyManager()  # recupero il gestore dei survey
        self.cache = Cache()  # recupero il gestore della cache

        self.subswath_in_bounds = [] # lista delle subswath che cadono all'interno della visualizzazione
        self.list_index_tile = [] # lista degli indici dei tile che cadono all'interno della visualizzazione

        self.minLat = None
        self.minLng = None
        self.maxLat = None
        self.maxLng = None

        # temp
        self.already_created_tomography = False
        self.tomo_inferenza = False

        self.th_raster_tile = Raster_tile()
        

    def run(self, minLat, minLng, maxLat, maxLng):
        self.minLat = minLat
        self.minLng = minLng
        self.maxLat = maxLat
        self.maxLng = maxLng
        self.rendering_tile_in_bounds(minLat, minLng, maxLat, maxLng)

    # AGGIORNO I BOUND DELLA MAPPA DELLA VISUALIZZAZIONE
    def rendering_tile_in_bounds(self, minLat, minLng, maxLat, maxLng):
        self.subswath_in_bounds, self.list_index_tile = self.tile_manager.rendering_tile_in_bounds(minLat, minLng, maxLat, maxLng)
        self.cache.update_cache(self.subswath_in_bounds, self.tomo_inferenza)
        self.update_map.emit()

    def update_depth_from_map(self):
        self.cache.update_cache(self.subswath_in_bounds, self.tomo_inferenza)
        self.update_map.emit()

    # TRUE: uso la tomografia inferenza | FALSE: uso la tomografia originale
    def switch_tomography(self, tomo_inferenza):
        if not self.already_created_tomography:
            # dico ad ogni subswath di prendere i radargrammi da current_filter li unisco e creo la tomografia
            self.survey_manager.create_tomography_inferenza()
            # creo la cache puntando alla cartella Data_current_filter
            # creo i file tomography e li metto nella cartella tomography_inferenza
            self.already_created_tomography = True
            #self.tile_manager.create_volume_raster()
            self.th_raster_tile.start()

        # svuoto la cache e creerò i raster puntando alla cartella tomography_inferenza
        self.cache.empty_cache()
        # Aggiorno il flag della tomografia inferenza
        self.tomo_inferenza = tomo_inferenza
        #self.cache.tomo_inferenza = tomo_inferenza
        #self.rendering_tile_in_bounds(self.minLat, self.minLng, self.maxLat, self.maxLng)


