from PySide6.QtWidgets import QProgressDialog, QApplication
from PySide6.QtCore import Qt


class ProgressBar:

    def __init__(self, view=None):

        self.view = view  # la mia finestra principale
        self.progress_dialog = None
    
    def show_progress_dialog(self, message="", modal=True):
        # Crea e configura la finestra di dialogo di caricamento centrata e più larga
        # modal=False permette interazione con la GUI durante il processamento
        self.progress_dialog = QProgressDialog(message, None, 0, 0, self.view)
        self.progress_dialog.setWindowTitle("Please wait")
        if modal:
            self.progress_dialog.setWindowModality(Qt.ApplicationModal)  # Blocca GUI
        else:
            self.progress_dialog.setWindowModality(Qt.NonModal)  # NON blocca GUI
        self.progress_dialog.setCancelButton(None)  # Rimuovi il pulsante di annullamento
        self.progress_dialog.setWindowFlags(Qt.FramelessWindowHint | Qt.Dialog)
        
        # Applica lo stile personalizzato
        self.progress_dialog.setStyleSheet("""
            QProgressDialog {
                background-color: #333;
                color: white;
                font-size: 14px;
                padding: 15px;
                border-radius: 8px;
                min-width: 300px;  /* Imposta una larghezza minima maggiore */
            }
            QProgressBar {
                background-color: #444;
                color: white;
                border: 2px solid #555;
                border-radius: 5px;
                text-align: center;
                height: 20px; /* Altezza della barra */
            }
        """)


        # Centra la finestra sullo schermo
        self._center_dialog()
        
        self.progress_dialog.show()
    
    def _center_dialog(self):
        """
        Centra la finestra di dialogo sullo schermo
        """
        if self.progress_dialog:
            screen_geometry = QApplication.primaryScreen().availableGeometry()
            dialog_geometry = self.progress_dialog.geometry()
            x = (screen_geometry.width() - dialog_geometry.width()) // 2
            y = (screen_geometry.height() - dialog_geometry.height()) // 2
            self.progress_dialog.move(x, y)
    
    
    def hide(self):

        if self.progress_dialog:
            self.progress_dialog.hide()
            self.progress_dialog = None
    
    def close(self):
        if self.progress_dialog:
            self.progress_dialog.close()
            self.progress_dialog = None
    

