from PySide6.QtWidgets import QApplication, QWidget, QPushButton, QHBoxLayout, QVBoxLayout, QLabel, QComboBox
from PySide6.QtCore import Qt, QSize
from PySide6.QtGui import QIcon

# STYLE
from style.StartWindow.StartWindow_css import *

# GLOBAL
from GLOBAL import *

class StartWindow(QWidget):
    def __init__(self):
        super().__init__()

        # Impostazioni finestra
        self.setWindowTitle("XMAP")
        self.setMinimumSize(900, 540)
        self.setMaximumSize(900, 540)
        self.setStyleSheet(window_style())

        # Layout orizzontale principale
        layout = QHBoxLayout()

        # ▼▼▼ Layout verticale per Import Survey + Dropdown ▼▼▼
        survey_layout = QVBoxLayout()
        survey_layout.setAlignment(Qt.AlignCenter)

        # 1) Creo Import survey
        self.import_survey_button = QPushButton()
        text_import_survey = QLabel("Import Survey")
        icon_import_survey = QLabel()
        icon_import_survey.setPixmap(QIcon(icon_path+'/import_survey.png').pixmap(50, 50))
        layout_import_survey = QVBoxLayout()
        layout_import_survey.addWidget(icon_import_survey, alignment=Qt.AlignBottom | Qt.AlignHCenter)
        layout_import_survey.addWidget(text_import_survey, alignment=Qt.AlignHCenter)
        self.import_survey_button.setStyleSheet(button_import_open())
        self.import_survey_button.setLayout(layout_import_survey)
        icon_import_survey.setStyleSheet(label_into_button())
        text_import_survey.setStyleSheet(label_into_button())
        self.import_survey_button.setFixedSize(200, 200)

        # ▼ ComboBox per tipo di survey ▼
        self.survey_type_dropdown = QComboBox()
        self.survey_type_dropdown.addItems([
            "Seleziona tipo survey...",
            "OGRP",
            "VOL",
            "ASCII",
            "VOL & ASCII",
            "SEGY",
            "DZT"
        ])
        self.survey_type_dropdown.setFixedSize(200, 40)

        # Aggiungo button e dropdown al layout verticale
        survey_layout.addWidget(self.import_survey_button, alignment=Qt.AlignCenter)
        survey_layout.addWidget(self.survey_type_dropdown, alignment=Qt.AlignTop)

        # 2) Creo Open project
        self.open_project_button = QPushButton()
        text_open_project = QLabel("Open Project")
        icon_open_project = QLabel()
        icon_open_project.setPixmap(QIcon(icon_path + '/open_project.png').pixmap(50, 50))
        layout_open_project = QVBoxLayout()
        layout_open_project.addWidget(icon_open_project, alignment=Qt.AlignBottom | Qt.AlignHCenter)
        layout_open_project.addWidget(text_open_project, alignment=Qt.AlignHCenter)
        self.open_project_button.setStyleSheet(button_import_open())
        self.open_project_button.setLayout(layout_open_project)
        icon_open_project.setStyleSheet(label_into_button())
        text_open_project.setStyleSheet(label_into_button())
        self.open_project_button.setFixedSize(200, 200)

        # Aggiungo layout al layout principale
        layout.addLayout(survey_layout)  # Pulsante import + dropdown
        layout.addWidget(self.open_project_button, alignment=Qt.AlignCenter)

        # Imposta il layout nella finestra
        self.setLayout(layout)

        self.closed_by_user = True

    def close_by_code(self):
        self.closed_by_user = False
        self.close()

if __name__ == "__main__":
    app = QApplication([])
    window = StartWindow()
    window.show()
    app.exec()
