import os
# Workaround temporaneo per conflitti OpenMP (libiomp5md.dll). Deve essere settato
# PRIMA che librerie scientifiche vengano importate.
os.environ.setdefault("KMP_DUPLICATE_LIB_OK", "TRUE")

# IMPORT PYSIDE6
from PySide6.QtWidgets import QApplication

#  IMPORT VIEW
from View.StartWindow import StartWindow
from View.MainWindow import MainWindow

# CONTROLLER
# start
from Controller.Start.StartController import StartController
# main
from Controller.Main.MainController import MainController
from Controller.Main.ElaborationController import ElaborationController
from Controller.Main.SurveyController import SurveyController
from Controller.Main.RadargramController import RadargramController
from Controller.Main.MapController import MapController

# MODELLI
from Model.SurveyManager import SurveyManager

# THREAD
from Thread.ApplyFilter import ApplyFilter

# GLOBAL
from GLOBAL import logger_dir

import os
import shutil
import logging

# creazione dei logger personalizzati
def setup_logger(name, log_file, level=logging.INFO):
    handler = logging.FileHandler(os.path.join(logger_dir, log_file), mode='w')
    handler.setFormatter(logging.Formatter('%(asctime)s - %(levelname)s - %(message)s'))
    logger = logging.getLogger(name)
    logger.setLevel(level)
    logger.addHandler(handler)

    return logger

if __name__ == "__main__":
    pc_Vale = True
    if pc_Vale:
        # Workaround: avoid D3D11 swapchain issues on some Windows drivers by using software rendering
        # and disabling RHI. This prevents 'GPU device instance suspended' errors.
        os.environ.setdefault("QT_OPENGL", "software")
        os.environ.setdefault("QT_QUICK_BACKEND", "software")
        os.environ.setdefault("QT_ENABLE_HIGHDPI_SCALING", "1")
        os.environ.setdefault("QT_QUICK_BACKEND", "software")
        os.environ.setdefault("QT_D3D_BASELINE_FEATURE_LEVEL", "11_0")
        os.environ.setdefault("QT_QUICK_BACKINGSTORE", "1")
        os.environ.setdefault("QT_RHI", "0")
    else:
        # Abilita accelerazione GPU su Windows con Qt 6 / QtWebEngine (ANGLE D3D11)
        # Nota: impostare prima della creazione di QApplication
        os.environ["QT_ENABLE_HIGHDPI_SCALING"] = "1"
        os.environ["QT_D3D_BASELINE_FEATURE_LEVEL"] = "11_0"
        # Forza ANGLE/OpenGL su D3D11 per il rendering compatibile con Chromium
        os.environ["QT_OPENGL"] = "angle"
        # Usa RHI su D3D11 per Qt Quick (default su Windows, esplicitato per stabilità)
        os.environ["QSG_RHI_BACKEND"] = "d3d11"
        # Abilita GPU e ANGLE in Chromium integrato (QtWebEngine)
        os.environ["QTWEBENGINE_DISABLE_SANDBOX"] = "1"
        os.environ["QTWEBENGINE_CHROMIUM_FLAGS"] = (
            "--use-angle=d3d11 "
            "--use-gl=angle "
            "--enable-gpu "
            "--enable-webgl "
            "--ignore-gpu-blocklist "
            "--disable-software-rasterizer "
            "--enable-zero-copy "
            "--canvas-oop-rasterization"
        ) 
    # GESTIONE CARTELLA TempData e Logger
    try:
        shutil.rmtree("TempData")
        shutil.rmtree("Logger")
        shutil.rmtree("Tiles")
    except:
        pass
    os.makedirs("TempData", exist_ok=True)
    os.makedirs("Logger", exist_ok=True)
    os.makedirs("Tiles", exist_ok=True)
    
    try:
        start_logger = setup_logger('start', 'start.log', level=logging.INFO)
        main_logger = setup_logger('main', 'main.log', level=logging.INFO)
        elaboration_logger = setup_logger('elaboration', 'elaboration.log', level=logging.INFO)
        map_logger = setup_logger('map', 'map.log', level=logging.INFO)
        radargram_logger = setup_logger('radargram', 'radargram.log', level=logging.INFO)
        survey_logger = setup_logger('survey', 'survey.log', level=logging.INFO)
        changed_logger = setup_logger('changed', 'changed.log', level=logging.INFO)
        survey_manager_logger = setup_logger('survey_manager', 'survey_manager.log', level=logging.INFO)
        filters_logger = setup_logger('filters', 'filters.log', level=logging.INFO)
    except Exception as e:
        print("NO LOG")

    #  CREAZIONE MODEL
    manager_survey = SurveyManager()

    # AVVIO DELLA PAGINA DI SCELTA TRA "IMPORT SURVEY" - "OPEN PROJECT"
    # creazione start window
    app = QApplication([])
    startWindow = StartWindow()
    startController = StartController(startWindow)
    startWindow.show()
    app.exec()

    if not startWindow.closed_by_user:
        del startController # forse

        # MAIN WINDOW
        window = MainWindow()

        # CREAZIONE DEI CONTROLLER
        mainController = MainController(window)
        elaborationController = ElaborationController(window)
        surveyController = SurveyController(window)
        radargramController = RadargramController(window)
        mapController = MapController(window)

        window.show()
        app.exec()

        # CHIUSURA DEI THREAD
        mapController.th_rendering.terminate()



